/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sequence;

import dragon.ir.index.BasicIRDocIndexList;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRCollection;
import dragon.ir.index.sequence.AbstractSequenceIndexWriter;
import dragon.ir.index.sequence.SequenceFileWriter;
import dragon.nlp.SimpleElementList;
import dragon.util.SortedArray;
import java.io.File;

public class BasicSequenceIndexWriter
extends AbstractSequenceIndexWriter {
    private FileIndex fileIndex;

    public BasicSequenceIndexWriter(String directory) {
        this.fileIndex = new FileIndex(directory, false);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.collection = new IRCollection();
        this.collection.load(this.fileIndex.getCollectionFilename());
        this.termCache = new SortedArray(500);
        this.docKeyList = new SimpleElementList(this.fileIndex.getDocKeyListFilename(), true);
        this.termKeyList = new SimpleElementList(this.fileIndex.getTermKeyListFilename(), true);
        this.docIndexList = new BasicIRDocIndexList(this.fileIndex.getDocIndexListFilename(), true);
        this.termIndexList = new BasicIRTermIndexList(this.fileIndex.getTermIndexListFilename(), true);
        this.doctermMatrix = new SequenceFileWriter(this.fileIndex.getDocTermSeqIndexFilename(), this.fileIndex.getDocTermSeqFilename());
        this.initialized = true;
    }

    public void close() {
        this.flush();
        this.collection.save(this.fileIndex.getCollectionFilename());
        this.docIndexList.close();
        this.termIndexList.close();
        this.doctermMatrix.close();
        this.docKeyList.close();
        this.termKeyList.close();
        this.initialized = false;
    }

    public void clean() {
        File file = new File(this.fileIndex.getDirectory());
        file.delete();
        file.mkdir();
    }
}

