/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index.sentence;

import dragon.ir.index.sentence.AbstractSentenceIndexer;
import dragon.ir.index.sentence.BasicSentenceWriteController;
import dragon.nlp.Sentence;
import dragon.nlp.extract.DualConceptExtractor;

public class DualSentenceIndexer
extends AbstractSentenceIndexer {
    private BasicSentenceWriteController firstWriter;
    private BasicSentenceWriteController secondWriter;
    private DualConceptExtractor cptExtractor;

    public DualSentenceIndexer(DualConceptExtractor extractor, String firstIndexFolder, String secondIndexFolder) {
        this(extractor, false, firstIndexFolder, false, secondIndexFolder);
    }

    public DualSentenceIndexer(DualConceptExtractor extractor, boolean useConcept, String firstIndexFolder, String secondIndexFolder) {
        this(extractor, useConcept, firstIndexFolder, useConcept, secondIndexFolder);
    }

    public DualSentenceIndexer(DualConceptExtractor extractor, boolean firstUseConcept, String firstIndexFolder, boolean secondUseConcept, String secondIndexFolder) {
        super(extractor.getDocumentParser());
        this.cptExtractor = extractor;
        this.firstWriter = new BasicSentenceWriteController(firstIndexFolder, false, firstUseConcept);
        this.secondWriter = new BasicSentenceWriteController(secondIndexFolder, false, secondUseConcept);
    }

    public boolean indexedSentence(String sentKey) {
        return this.firstWriter.indexed(sentKey);
    }

    public boolean index(Sentence sent, String sentKey) {
        try {
            if (this.firstWriter.indexed(sentKey)) {
                return false;
            }
            this.firstWriter.addRawSentence(sent);
            this.cptExtractor.initDocExtraction();
            this.cptExtractor.extractFromSentence(sent);
            this.firstWriter.write(this.cptExtractor.getFirstConceptList());
            this.secondWriter.write(this.cptExtractor.getSecondConceptList());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.firstWriter.initialize();
        this.secondWriter.initialize();
        this.initialized = true;
    }

    public void close() {
        this.firstWriter.close();
        this.secondWriter.close();
        super.close();
    }
}

