/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexWriteController;
import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.OnlineIndexWriter;
import dragon.matrix.IntSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import java.util.ArrayList;

public class OnlineIndexWriteController
extends AbstractIndexWriteController {
    private OnlineIndexWriter indexWriter;

    public OnlineIndexWriteController(boolean relationSupported, boolean indexConceptEntry) {
        super(relationSupported, indexConceptEntry);
        this.curDocIndex = -1;
        this.curDocKey = null;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.docKeyList = new SimpleElementList();
        this.termKeyList = new SimpleElementList();
        if (this.relationSupported) {
            this.relationKeyList = new SimplePairList();
        }
        this.indexWriter = new OnlineIndexWriter(this.relationSupported);
        this.indexWriter.initialize();
        this.initialized = true;
    }

    public void close() {
        this.indexWriter.close();
        this.initialized = false;
    }

    public boolean write(ArrayList conceptList) {
        try {
            if (this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(new String(this.curDocKey));
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            return this.indexWriter.write(curDoc, arrTerms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write(ArrayList conceptList, ArrayList tripleList) {
        try {
            if (this.curDocKey == null) {
                return false;
            }
            IRDoc curDoc = new IRDoc(new String(this.curDocKey));
            curDoc.setIndex(this.curDocIndex);
            IRTerm[] arrTerms = this.getIRTermArray(this.generateIRTermList(conceptList), curDoc);
            IRRelation[] arrRelations = this.getIRRelationArray(this.generateIRRelationList(tripleList), curDoc);
            return this.indexWriter.write(curDoc, arrTerms, arrRelations);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SimpleElementList getDocKeyList() {
        return this.docKeyList;
    }

    public SimpleElementList getTermKeyList() {
        return this.termKeyList;
    }

    public SimplePairList getRelationKeyList() {
        return this.relationKeyList;
    }

    public IRTermIndexList getTermIndexList() {
        return this.indexWriter.getTermIndexList();
    }

    public IRRelationIndexList getRelationIndexList() {
        return this.indexWriter.getRelationIndexList();
    }

    public IRDocIndexList getDocIndexList() {
        return this.indexWriter.getDocIndexList();
    }

    public IntSparseMatrix getDocTermMatrix() {
        return this.indexWriter.getDocTermMatrix();
    }

    public IntSparseMatrix getDocRelationMatrix() {
        return this.indexWriter.getDocRelationMatrix();
    }

    public IRCollection getIRCollection() {
        return this.indexWriter.getIRCollection();
    }
}

