/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRSignature;
import dragon.nlp.compare.FrequencySortable;
import dragon.nlp.compare.IndexSortable;
import java.io.Serializable;

public class IRTerm
implements IRSignature,
IndexSortable,
FrequencySortable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String key;
    private int docFrequency;
    private int frequency;
    private int index;

    public IRTerm(String key) {
        this.key = key;
        this.docFrequency = 0;
        this.frequency = 0;
        this.index = -1;
    }

    public IRTerm(int index, int frequency) {
        this.key = null;
        this.docFrequency = 0;
        this.frequency = frequency;
        this.index = index;
    }

    public IRTerm(String key, int index, int frequency) {
        this.key = key;
        this.docFrequency = 0;
        this.frequency = frequency;
        this.index = index;
    }

    public IRTerm(int index, int frequency, int docFrequency) {
        this.key = null;
        this.docFrequency = docFrequency;
        this.frequency = frequency;
        this.index = index;
    }

    public IRTerm copy() {
        IRTerm cur = new IRTerm(this.index, this.frequency, this.docFrequency);
        cur.setKey(this.key);
        return cur;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    public void addFrequency(int inc) {
        this.frequency += inc;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getDocFrequency() {
        return this.docFrequency;
    }

    public void addDocFrequency(int inc) {
        this.docFrequency += inc;
    }

    public void setDocFrequency(int freq) {
        this.docFrequency = freq;
    }

    public int compareTo(Object obj) {
        return this.key.compareToIgnoreCase(((IRTerm)obj).getKey());
    }
}

