/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IndexReader;
import dragon.ir.index.IndexWriter;

public class IRSection
implements Comparable {
    public static final int SEC_ALL = 0;
    public static final int SEC_TITLE = 1;
    public static final int SEC_ABSTRACT = 2;
    public static final int SEC_BODY = 3;
    public static final int SEC_META = 4;
    public static final int DEF_SEC_NUM = 4;
    private int id;
    private String name;
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private boolean enabled;
    private double weight;

    public IRSection(int section) {
        this.id = section;
        switch (section) {
            case 1: {
                this.name = "title";
                break;
            }
            case 2: {
                this.name = "absract";
                break;
            }
            case 3: {
                this.name = "body";
                break;
            }
            case 4: {
                this.name = "meta";
                break;
            }
            default: {
                this.name = "all";
            }
        }
        this.enabled = true;
        this.weight = 1.0;
    }

    public IRSection(int section, String name) {
        this.id = section;
        this.name = name;
        this.enabled = true;
    }

    public IRSection copy() {
        IRSection cur = new IRSection(this.id, this.name);
        if (this.enabled()) {
            cur.enable();
        } else {
            cur.disable();
        }
        cur.setIndexReader(this.getIndexReader());
        cur.setIndexWriter(this.getIndexWriter());
        cur.setWeight(this.getWeight());
        return cur;
    }

    public int compareTo(Object obj) {
        int objID = ((IRSection)obj).getSectionID();
        if (this.id == objID) {
            return 0;
        }
        if (this.id > objID) {
            return 1;
        }
        return -1;
    }

    public String getSectionName() {
        return this.name;
    }

    public int getSectionID() {
        return this.id;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public void setIndexWriter(IndexWriter writer) {
        this.indexWriter = writer;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public void setIndexReader(IndexReader reader) {
        this.indexReader = reader;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }
}

