/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.BasicIndexWriteController;
import dragon.ir.index.IRSection;
import dragon.ir.index.Indexer;
import dragon.nlp.extract.DualConceptExtractor;
import dragon.onlinedb.Article;
import dragon.util.FileUtil;
import java.io.PrintWriter;
import java.util.Date;

public class DualIndexer
implements Indexer {
    private PrintWriter log;
    protected BasicIndexWriteController firstWriter;
    protected BasicIndexWriteController secondWriter;
    protected boolean relationSupported;
    protected boolean initialized;
    protected DualConceptExtractor extractor;
    protected boolean firstUseConcept;
    protected boolean secondUseConcept;

    public DualIndexer(DualConceptExtractor extractor, String firstIndexFolder, String secondIndexFolder) {
        this(extractor, false, firstIndexFolder, false, secondIndexFolder);
    }

    public DualIndexer(DualConceptExtractor extractor, boolean useConcept, String firstIndexFolder, String secondIndexFolder) {
        this(extractor, useConcept, firstIndexFolder, useConcept, secondIndexFolder);
    }

    public DualIndexer(DualConceptExtractor extractor, boolean firstUseConcept, String firstIndexFolder, boolean secondUseConcept, String secondIndexFolder) {
        this.extractor = extractor;
        this.firstUseConcept = firstUseConcept;
        this.relationSupported = false;
        this.firstWriter = new BasicIndexWriteController(firstIndexFolder, this.relationSupported, firstUseConcept);
        this.secondWriter = new BasicIndexWriteController(secondIndexFolder, this.relationSupported, secondUseConcept);
        this.log = null;
        this.initialized = false;
    }

    public void setLog(String logFile) {
        this.log = FileUtil.getPrintWriter(logFile);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.firstWriter.addSection(new IRSection(0));
        this.secondWriter.addSection(new IRSection(0));
        this.initialized = true;
    }

    public void close() {
        this.initialized = false;
        this.firstWriter.close();
        this.secondWriter.close();
    }

    public synchronized boolean index(Article article) {
        try {
            boolean ret;
            if (!this.initialized) {
                return false;
            }
            this.writeLog(new Date().toString());
            this.writeLog("Indexing article #" + article.getKey() + ": ");
            this.extractor.initDocExtraction();
            boolean bl = ret = this.firstWriter.indexed(article.getKey()) || this.secondWriter.indexed(article.getKey());
            if (ret) {
                this.writeLog("indexed\n");
                return false;
            }
            ret = this.extractor.extractFromDoc(article);
            if (ret) {
                this.firstWriter.setDoc(article.getKey());
                this.firstWriter.write(0, this.extractor.getFirstConceptList());
                this.secondWriter.setDoc(article.getKey());
                this.secondWriter.write(0, this.extractor.getSecondConceptList());
                this.writeLog("succeeded\r\n");
                return true;
            }
            this.writeLog("failed\r\n");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeLog("failed\r\n");
            return false;
        }
    }

    public boolean indexed(String docKey) {
        return this.firstWriter.indexed(docKey);
    }

    protected void writeLog(String content) {
        if (this.log != null) {
            this.log.write(content);
            this.log.flush();
        }
    }
}

