/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.AbstractIndexReader;
import dragon.ir.index.BasicIRDocIndexList;
import dragon.ir.index.BasicIRRelationIndexList;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.index.FileIndex;
import dragon.ir.index.IRCollection;
import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.onlinedb.CollectionReader;
import java.io.File;

public class BasicIndexReader
extends AbstractIndexReader {
    private FileIndex fileIndex;

    public BasicIndexReader(String directory, boolean relationSupported) {
        this(directory, relationSupported, null);
    }

    public BasicIndexReader(String directory, boolean relationSupported, CollectionReader collectionReader) {
        super(relationSupported);
        this.relationSupported = relationSupported;
        this.collectionReader = collectionReader;
        this.fileIndex = new FileIndex(directory, relationSupported);
    }

    public void initialize() {
        this.collection = new IRCollection();
        this.collection.load(this.fileIndex.getCollectionFilename());
        this.termIndexList = new BasicIRTermIndexList(this.fileIndex.getTermIndexListFilename(), false);
        this.docIndexList = new BasicIRDocIndexList(this.fileIndex.getDocIndexListFilename(), false);
        this.termdocMatrix = new IntSuperSparseMatrix(this.fileIndex.getTermDocIndexFilename(), this.fileIndex.getTermDocFilename());
        this.doctermMatrix = new IntGiantSparseMatrix(this.fileIndex.getDocTermIndexFilename(), this.fileIndex.getDocTermFilename());
        if (new File(this.fileIndex.getDocKeyListFilename()).exists()) {
            this.docKeyList = new SimpleElementList(this.fileIndex.getDocKeyListFilename(), false);
        }
        if (new File(this.fileIndex.getTermKeyListFilename()).exists()) {
            this.termKeyList = new SimpleElementList(this.fileIndex.getTermKeyListFilename(), false);
        }
        if (this.relationSupported) {
            this.relationIndexList = new BasicIRRelationIndexList(this.fileIndex.getRelationIndexListFilename(), false);
            this.relationdocMatrix = new IntGiantSparseMatrix(this.fileIndex.getRelationDocIndexFilename(), this.fileIndex.getRelationDocFilename());
            this.docrelationMatrix = new IntGiantSparseMatrix(this.fileIndex.getDocRelationIndexFilename(), this.fileIndex.getDocRelationFilename());
        }
    }
}

