/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRRelation;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRSignature;
import dragon.ir.index.IRSignatureIndexList;
import dragon.nlp.compare.IndexComparator;
import dragon.util.ByteArrayConvert;
import dragon.util.FastBinaryReader;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.RandomAccessFile;
import java.util.Date;

public class BasicIRRelationIndexList
implements IRRelationIndexList,
IRSignatureIndexList {
    private RandomAccessFile raf;
    private SortedArray indexList;
    private int elementLength;
    private boolean writingMode;
    private String indexlistFilename;
    private int relationNum;
    private int maxOldIndex;
    private int maxIndex;
    private int maxCacheSize;
    private byte[] buf;

    public BasicIRRelationIndexList(String filename, boolean writingMode) {
        block7: {
            try {
                this.elementLength = 20;
                this.buf = new byte[this.elementLength];
                this.writingMode = writingMode;
                this.indexlistFilename = filename;
                this.maxCacheSize = 200000;
                if (writingMode) {
                    this.raf = new RandomAccessFile(filename, "rw");
                    if (this.raf.length() < 4L) {
                        this.raf.writeInt(0);
                        this.maxOldIndex = -1;
                    } else {
                        this.maxOldIndex = this.raf.readInt() - 1;
                    }
                    this.maxIndex = this.maxOldIndex;
                    this.raf.close();
                    this.raf = null;
                    this.indexList = new SortedArray(new IndexComparator());
                    break block7;
                }
                if (FileUtil.exist(filename)) {
                    this.raf = new RandomAccessFile(filename, "r");
                    this.relationNum = this.raf.length() > 0L ? this.raf.readInt() : 0;
                } else {
                    this.relationNum = 0;
                }
                this.maxIndex = this.relationNum - 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCacheSize(int size2) {
        this.maxCacheSize = size2;
    }

    public int getCacheSize() {
        return this.maxCacheSize;
    }

    public IRSignature getIRSignature(int index) {
        return this.get(index);
    }

    public IRRelation get(int index) {
        try {
            if (this.writingMode || index >= this.relationNum) {
                return null;
            }
            this.raf.seek(index * this.elementLength + 4);
            this.raf.read(this.buf);
            return this.getIRRelationFromByteArray(this.buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean add(IRRelation curRelation) {
        if (!this.writingMode) {
            return false;
        }
        if (!this.indexList.add(curRelation.copy())) {
            IRRelation oldRelation = (IRRelation)this.indexList.get(this.indexList.insertedPos());
            oldRelation.addFrequency(curRelation.getFrequency());
            oldRelation.setDocFrequency(oldRelation.getDocFrequency() + curRelation.getDocFrequency());
        } else {
            if (curRelation.getIndex() > this.maxIndex) {
                this.maxIndex = curRelation.getIndex();
            }
            if (this.indexList.size() > this.maxCacheSize) {
                this.saveRelationIndexList(this.indexlistFilename, this.indexList);
            }
        }
        return true;
    }

    public int size() {
        return this.maxIndex + 1;
    }

    public void close() {
        try {
            if (this.writingMode) {
                this.saveRelationIndexList(this.indexlistFilename, this.indexList);
                this.indexList.clear();
            } else if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveRelationIndexList(String filename, SortedArray list2) {
        try {
            IRRelation cur;
            if (list2 == null || list2.size() == 0) {
                return;
            }
            System.out.println(new Date() + " Saving Relation Index List...");
            FastBinaryReader fbr = new FastBinaryReader(filename);
            fbr.skip(4L);
            int lastIndex = 0;
            int i = 0;
            while (i < list2.size()) {
                cur = (IRRelation)list2.get(i);
                if (cur.getIndex() > this.maxOldIndex) break;
                fbr.skip((cur.getIndex() - lastIndex) * this.elementLength + 12);
                cur.addFrequency(fbr.readInt());
                cur.setDocFrequency(cur.getDocFrequency() + fbr.readInt());
                lastIndex = cur.getIndex() + 1;
                ++i;
            }
            int cutoff = i - 1;
            fbr.close();
            RandomAccessFile rafRelation = new RandomAccessFile(filename, "rw");
            rafRelation.writeInt(this.maxIndex + 1);
            i = 0;
            while (i <= cutoff) {
                cur = (IRRelation)list2.get(i);
                rafRelation.seek(cur.getIndex() * this.elementLength + 4);
                this.writeToByteArray(cur, this.buf);
                rafRelation.write(this.buf);
                ++i;
            }
            lastIndex = this.maxOldIndex;
            rafRelation.seek((this.maxOldIndex + 1) * this.elementLength + 4);
            i = cutoff + 1;
            while (i < list2.size()) {
                cur = (IRRelation)list2.get(i);
                int j = lastIndex + 1;
                while (j < cur.getIndex()) {
                    this.writeToByteArray(j, this.buf);
                    rafRelation.write(this.buf);
                    ++j;
                }
                this.writeToByteArray(cur, this.buf);
                rafRelation.write(this.buf);
                lastIndex = cur.getIndex();
                ++i;
            }
            rafRelation.close();
            this.maxOldIndex = this.maxIndex;
            list2.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writeToByteArray(IRRelation cur, byte[] array) {
        ByteArrayConvert.toByte(cur.getIndex(), array, 0);
        ByteArrayConvert.toByte(cur.getFirstTerm(), array, 4);
        ByteArrayConvert.toByte(cur.getSecondTerm(), array, 8);
        ByteArrayConvert.toByte(cur.getFrequency(), array, 12);
        ByteArrayConvert.toByte(cur.getDocFrequency(), array, 16);
    }

    private void writeToByteArray(int index, byte[] array) {
        ByteArrayConvert.toByte(index, array, 0);
        ByteArrayConvert.toByte(-1, array, 4);
        ByteArrayConvert.toByte(-1, array, 8);
        ByteArrayConvert.toByte(0, array, 12);
        ByteArrayConvert.toByte(0, array, 16);
    }

    private IRRelation getIRRelationFromByteArray(byte[] array) {
        int relationIndex = ByteArrayConvert.toInt(array, 0);
        int first = ByteArrayConvert.toInt(array, 4);
        int second = ByteArrayConvert.toInt(array, 8);
        int frequency = ByteArrayConvert.toInt(array, 12);
        int docFrequency = ByteArrayConvert.toInt(array, 16);
        return new IRRelation(relationIndex, first, second, frequency, docFrequency);
    }
}

