/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;

public class BasicIRDocIndexList
implements IRDocIndexList {
    private static int doc_cache_size = 5000;
    private FastBinaryWriter fbw;
    private ArrayList indexList;
    private boolean writingMode;
    private String indexlistFilename;
    private int docNum;
    private int lastDocIndex;
    private int doc_in_cache;

    public BasicIRDocIndexList(String filename, boolean writingMode) {
        block4: {
            try {
                this.writingMode = writingMode;
                this.indexlistFilename = filename;
                if (writingMode) {
                    this.doc_in_cache = 0;
                    this.fbw = new FastBinaryWriter(filename, true);
                    if (this.fbw.getFilePointer() < 4L) {
                        this.fbw.writeInt(0);
                    }
                    this.lastDocIndex = ((int)this.fbw.getFilePointer() - 4) / 20 - 1;
                    break block4;
                }
                this.indexList = this.loadDocIndexList(filename);
                this.docNum = this.indexList.size();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IRDoc get(int index) {
        return index < this.docNum ? (IRDoc)this.indexList.get(index) : null;
    }

    public boolean add(IRDoc curDoc) {
        try {
            if (!this.writingMode || curDoc.getIndex() <= this.lastDocIndex) {
                return false;
            }
            int i = this.lastDocIndex + 1;
            while (i < curDoc.getIndex()) {
                ++this.doc_in_cache;
                this.fbw.writeInt(i);
                this.fbw.writeInt(0);
                this.fbw.writeInt(0);
                this.fbw.writeInt(0);
                this.fbw.writeInt(0);
                ++i;
            }
            this.fbw.writeInt(curDoc.getIndex());
            this.fbw.writeInt(curDoc.getTermNum());
            this.fbw.writeInt(curDoc.getTermCount());
            this.fbw.writeInt(curDoc.getRelationNum());
            this.fbw.writeInt(curDoc.getRelationCount());
            ++this.doc_in_cache;
            if (this.doc_in_cache >= doc_cache_size) {
                this.flush();
            }
            this.lastDocIndex = curDoc.getIndex();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        block3: {
            try {
                if (this.writingMode) {
                    this.fbw.close();
                    RandomAccessFile raf = new RandomAccessFile(this.indexlistFilename, "rw");
                    raf.writeInt(this.lastDocIndex + 1);
                    raf.close();
                    break block3;
                }
                this.indexList.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int size() {
        if (this.writingMode) {
            return this.lastDocIndex + 1;
        }
        return this.docNum;
    }

    private void flush() {
        if (this.writingMode && this.fbw != null) {
            this.fbw.flush();
            this.doc_in_cache = 0;
        }
    }

    private ArrayList loadDocIndexList(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return new ArrayList();
            }
            System.out.println(new Date() + " Loading Document List...");
            FastBinaryReader br = new FastBinaryReader(filename);
            int total = br.readInt();
            ArrayList<IRDoc> list2 = new ArrayList<IRDoc>(total);
            int i = 0;
            while (i < total) {
                IRDoc cur = new IRDoc(br.readInt());
                cur.setTermNum(br.readInt());
                cur.setTermCount(br.readInt());
                cur.setRelationNum(br.readInt());
                cur.setRelationCount(br.readInt());
                list2.add(cur);
                ++i;
            }
            br.close();
            br.close();
            return list2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

