/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRDoc;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRTerm;
import dragon.nlp.Concept;
import dragon.nlp.SimpleElementList;
import dragon.nlp.SimplePairList;
import dragon.nlp.Triple;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public abstract class AbstractIndexWriteController {
    protected SimpleElementList termKeyList;
    protected SimpleElementList docKeyList;
    protected SimplePairList relationKeyList;
    protected int curDocIndex;
    protected String curDocKey;
    protected int processedDoc;
    protected boolean relationSupported;
    protected boolean initialized;
    private SortedArray termList;
    private SortedArray relationList;
    private boolean indexConceptEntry;

    public AbstractIndexWriteController(boolean relationSupported, boolean indexConceptEntry) {
        this.relationSupported = relationSupported;
        this.indexConceptEntry = indexConceptEntry;
        this.processedDoc = 0;
        this.initialized = false;
        this.termList = new SortedArray();
        if (relationSupported) {
            this.relationList = new SortedArray();
        }
    }

    public abstract void initialize();

    public boolean indexed(String docKey) {
        return this.docKeyList.contains(docKey);
    }

    public int size() {
        return this.processedDoc;
    }

    public boolean isRelationSupported() {
        return this.relationSupported;
    }

    public boolean setDoc(String docKey) {
        this.curDocIndex = this.docKeyList.add(docKey);
        this.termList.clear();
        if (this.relationSupported) {
            this.relationList.clear();
        }
        if (this.curDocIndex == this.docKeyList.size() - 1) {
            this.curDocKey = docKey;
            ++this.processedDoc;
            return true;
        }
        this.curDocKey = null;
        return false;
    }

    protected IRTerm[] getIRTermArray(ArrayList irtermList, IRDoc curDoc) {
        IRTerm[] arrTerms = new IRTerm[irtermList.size()];
        curDoc.setTermNum(arrTerms.length);
        int count2 = 0;
        int i = 0;
        while (i < irtermList.size()) {
            arrTerms[i] = (IRTerm)irtermList.get(i);
            count2 += arrTerms[i].getFrequency();
            ++i;
        }
        curDoc.setTermCount(count2);
        return arrTerms;
    }

    protected IRRelation[] getIRRelationArray(ArrayList irRelationList, IRDoc curDoc) {
        IRRelation[] arrRelations = new IRRelation[irRelationList.size()];
        curDoc.setRelationNum(arrRelations.length);
        int count2 = 0;
        int i = 0;
        while (i < irRelationList.size()) {
            arrRelations[i] = (IRRelation)irRelationList.get(i);
            count2 += arrRelations[i].getFrequency();
            ++i;
        }
        curDoc.setRelationCount(count2);
        return arrRelations;
    }

    protected SortedArray generateIRTermList(ArrayList termList) {
        SortedArray newList = new SortedArray();
        int i = 0;
        while (i < termList.size()) {
            IRTerm curIRTerm = this.getIRTerm((Concept)termList.get(i));
            if (!newList.add(curIRTerm)) {
                ((IRTerm)newList.get(newList.insertedPos())).addFrequency(curIRTerm.getFrequency());
            }
            ++i;
        }
        return newList;
    }

    protected SortedArray generateIRRelationList(ArrayList tripleList) {
        SortedArray newList = new SortedArray(new IndexComparator());
        int i = 0;
        while (i < tripleList.size()) {
            IRRelation curIRRelation = this.getIRRelation((Triple)tripleList.get(i));
            if (!newList.add(curIRRelation)) {
                ((IRRelation)newList.get(newList.insertedPos())).addFrequency(curIRRelation.getFrequency());
            }
            ++i;
        }
        return newList;
    }

    private IRRelation getIRRelation(Triple triple2) {
        int second;
        int first = this.getIRTerm(triple2.getFirstConcept()).getIndex();
        IRRelation cur = first > (second = this.getIRTerm(triple2.getSecondConcept()).getIndex()) ? new IRRelation(second, first, triple2.getFrequency()) : new IRRelation(first, second, triple2.getFrequency());
        if (this.relationList.add(cur)) {
            int index = this.relationKeyList.add(cur.getFirstTerm(), cur.getSecondTerm());
            cur.setIndex(index);
        } else {
            cur.setIndex(((IRRelation)this.relationList.get(this.relationList.insertedPos())).getIndex());
        }
        return cur;
    }

    private IRTerm getIRTerm(Concept concept) {
        IRTerm cur = this.indexConceptEntry ? new IRTerm(new String(concept.getEntryID()), -1, concept.getFrequency()) : new IRTerm(new String(concept.getName()), -1, concept.getFrequency());
        if (this.termList.add(cur)) {
            int index = this.termKeyList.add(cur.getKey());
            cur.setIndex(index);
        } else {
            cur.setIndex(((IRTerm)this.termList.get(this.termList.insertedPos())).getIndex());
        }
        return cur;
    }
}

