/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.index;

import dragon.ir.index.IRCollection;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRDocIndexList;
import dragon.ir.index.IRRelation;
import dragon.ir.index.IRRelationIndexList;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IRTermIndexList;
import dragon.ir.index.IndexReader;
import dragon.matrix.IntCell;
import dragon.matrix.IntSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;

public abstract class AbstractIndexReader
implements IndexReader {
    protected CollectionReader collectionReader;
    protected SimpleElementList termKeyList;
    protected IRTermIndexList termIndexList;
    protected IRRelationIndexList relationIndexList;
    protected SimpleElementList docKeyList;
    protected IRDocIndexList docIndexList;
    protected IntSparseMatrix termdocMatrix;
    protected IntSparseMatrix doctermMatrix;
    protected IntSparseMatrix relationdocMatrix;
    protected IntSparseMatrix docrelationMatrix;
    protected boolean relationSupported;
    protected boolean initialized;
    protected IRCollection collection;

    public AbstractIndexReader(boolean relationSupported) {
        this(relationSupported, null);
    }

    public AbstractIndexReader(boolean relationSupported, CollectionReader collectionReader) {
        this.relationSupported = relationSupported;
        this.collectionReader = collectionReader;
    }

    public IntSparseMatrix getDocTermMatrix() {
        return this.doctermMatrix;
    }

    public IntSparseMatrix getTermDocMatrix() {
        return this.termdocMatrix;
    }

    public IntSparseMatrix getDocRelationMatrix() {
        return this.docrelationMatrix;
    }

    public IntSparseMatrix getRelaitonDocMatrix() {
        return this.relationdocMatrix;
    }

    public void close() {
        this.termIndexList.close();
        this.docIndexList.close();
        this.termdocMatrix.close();
        this.doctermMatrix.close();
        if (this.relationSupported) {
            this.relationdocMatrix.close();
            this.docrelationMatrix.close();
            this.relationIndexList.close();
        }
        this.initialized = false;
    }

    public boolean isRelationSupported() {
        return this.relationSupported;
    }

    public void setIRDocKeyList(SimpleElementList keyList) {
        this.docKeyList = keyList;
    }

    public void setIRTermKeyList(SimpleElementList keyList) {
        this.termKeyList = keyList;
    }

    public IRTerm getIRTerm(int index) {
        return this.termIndexList.get(index);
    }

    public String getTermKey(int index) {
        return this.termKeyList.search(index);
    }

    public IRTerm getIRTerm(String key) {
        int pos = this.termKeyList.search(key);
        if (pos >= 0) {
            IRTerm cur = this.termIndexList.get(pos);
            cur.setKey(key);
            return cur;
        }
        return null;
    }

    public IRTerm getIRTerm(int termIndex, int docIndex) {
        IntCell cell = (IntCell)this.termdocMatrix.getCell(termIndex, docIndex);
        if (cell == null) {
            return null;
        }
        return new IRTerm(termIndex, cell.getIntScore());
    }

    public IRTerm[] getTermList(int docIndex) {
        int len = this.doctermMatrix.getNonZeroNumInRow(docIndex);
        IRTerm[] arrTerm = new IRTerm[len];
        int i = 0;
        while (i < len) {
            IntCell curCell = (IntCell)this.doctermMatrix.getNonZeroCellInRow(docIndex, i);
            arrTerm[i] = new IRTerm(curCell.getColumn(), curCell.getIntScore());
            ++i;
        }
        return arrTerm;
    }

    public int[] getTermFrequencyList(int docIndex) {
        return this.doctermMatrix.getNonZeroIntScoresInRow(docIndex);
    }

    public int[] getTermIndexList(int docIndex) {
        return this.doctermMatrix.getNonZeroColumnsInRow(docIndex);
    }

    public IRRelation getIRRelation(int index) {
        return this.relationIndexList.get(index);
    }

    public IRRelation getIRRelation(int relationIndex, int docIndex) {
        IntCell cell = (IntCell)this.docrelationMatrix.getCell(docIndex, relationIndex);
        return new IRRelation(relationIndex, -1, -1, cell.getIntScore(), 0);
    }

    public int[] getRelationIndexList(int docIndex) {
        return this.docrelationMatrix.getNonZeroColumnsInRow(docIndex);
    }

    public int[] getRelationFrequencyList(int docIndex) {
        return this.docrelationMatrix.getNonZeroIntScoresInRow(docIndex);
    }

    public IRRelation[] getRelationList(int docIndex) {
        int len = this.docrelationMatrix.getNonZeroNumInRow(docIndex);
        IRRelation[] arrRelation = new IRRelation[len];
        int i = 0;
        while (i < len) {
            IntCell cell = (IntCell)this.docrelationMatrix.getNonZeroCellInRow(docIndex, i);
            arrRelation[i] = new IRRelation(cell.getColumn(), -1, -1, cell.getIntScore(), 0);
            ++i;
        }
        return arrRelation;
    }

    public IRCollection getCollection() {
        return this.collection;
    }

    public IRDoc getDoc(int index) {
        return this.docIndexList.get(index).copy();
    }

    public String getDocKey(int index) {
        return this.docKeyList.search(index);
    }

    public IRDoc getDoc(String key) {
        int index = this.docKeyList.search(key);
        if (index >= 0) {
            IRDoc cur = this.getDoc(index);
            cur.setKey(key);
            return cur;
        }
        return null;
    }

    public Article getOriginalDoc(String key) {
        if (this.collectionReader == null) {
            System.out.println("Collection Reader is not set yet!");
            return null;
        }
        return this.collectionReader.getArticleByKey(key);
    }

    public Article getOriginalDoc(int index) {
        return this.getOriginalDoc(this.getDocKey(index));
    }

    public int[] getTermDocIndexList(int termIndex) {
        return this.termdocMatrix.getNonZeroColumnsInRow(termIndex);
    }

    public IRDoc[] getTermDocList(int termIndex) {
        int[] arrDocIndex = this.getTermDocIndexList(termIndex);
        IRDoc[] arrDoc = new IRDoc[arrDocIndex.length];
        int i = 0;
        while (i < arrDocIndex.length) {
            arrDoc[i] = this.getDoc(arrDocIndex[i]);
            ++i;
        }
        return arrDoc;
    }

    public int[] getTermDocFrequencyList(int termIndex) {
        return this.termdocMatrix.getNonZeroIntScoresInRow(termIndex);
    }

    public int[] getRelationDocFrequencyList(int relationIndex) {
        return this.relationdocMatrix.getNonZeroIntScoresInRow(relationIndex);
    }

    public IRDoc[] getRelationDocList(int relationIndex) {
        int[] arrDocIndex = this.getRelationDocIndexList(relationIndex);
        IRDoc[] arrDoc = new IRDoc[arrDocIndex.length];
        int i = 0;
        while (i < arrDocIndex.length) {
            arrDoc[i] = this.getDoc(arrDocIndex[i]);
            ++i;
        }
        return arrDoc;
    }

    public int[] getRelationDocIndexList(int relationIndex) {
        return this.relationdocMatrix.getNonZeroColumnsInRow(relationIndex);
    }
}

