/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.docdistance;

import dragon.ir.clustering.docdistance.AbstractDocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleSparseMatrix;

public class KLDivDocDistance
extends AbstractDocDistance {
    private double bkgCoefficient = 0.1;
    private double normThreshold;
    private double[] arrBkgModel;
    private boolean norm;

    public KLDivDocDistance(DoubleSparseMatrix docModelMatrix) {
        this(docModelMatrix, 0.0);
    }

    public KLDivDocDistance(DoubleSparseMatrix doctermMatrix, double normThreshold) {
        super(doctermMatrix);
        int termNum = this.matrix.columns();
        this.arrBkgModel = new double[termNum];
        int i = 0;
        while (i < termNum) {
            this.arrBkgModel[i] = this.bkgCoefficient / (double)termNum;
            ++i;
        }
        if (normThreshold > 0.0) {
            this.norm = true;
            this.normThreshold = normThreshold;
        } else {
            this.norm = false;
            this.normThreshold = 0.0;
        }
    }

    public KLDivDocDistance(IndexReader indexReader, DoubleSparseMatrix docModelMatrix) {
        this(indexReader, docModelMatrix, 0.0);
    }

    public KLDivDocDistance(IndexReader indexReader, DoubleSparseMatrix doctermMatrix, double normThreshold) {
        super(doctermMatrix);
        int termNum = indexReader.getCollection().getTermNum();
        this.arrBkgModel = new double[termNum];
        double totalTermCount = indexReader.getCollection().getTermCount();
        int i = 0;
        while (i < termNum) {
            this.arrBkgModel[i] = (double)indexReader.getIRTerm(i).getFrequency() / totalTermCount * this.bkgCoefficient;
            ++i;
        }
        if (normThreshold > 0.0) {
            this.norm = true;
            this.normThreshold = normThreshold;
        } else {
            this.norm = false;
            this.normThreshold = 0.0;
        }
    }

    /*
     * Unable to fully structure code
     */
    public double getDistance(IRDoc first, IRDoc second) {
        arrFirstIndex = this.matrix.getNonZeroColumnsInRow(first.getIndex());
        arrFirstScore = this.matrix.getNonZeroDoubleScoresInRow(first.getIndex());
        firstCount = this.matrix.getNonZeroNumInRow(first.getIndex());
        arrSecondIndex = this.matrix.getNonZeroColumnsInRow(second.getIndex());
        arrSecondScore = this.matrix.getNonZeroDoubleScoresInRow(second.getIndex());
        secondCount = this.matrix.getNonZeroNumInRow(second.getIndex());
        distance = 0.0;
        i = 0;
        j = 0;
        ** GOTO lbl18
        {
            ++j;
            do {
                if (j < secondCount && arrSecondIndex[j] < arrFirstIndex[i]) continue block0;
                secondProb = j >= secondCount || arrSecondIndex[j] != arrFirstIndex[i] ? this.arrBkgModel[arrFirstIndex[i]] : (1.0 - this.bkgCoefficient) * arrSecondScore[j] + this.arrBkgModel[arrFirstIndex[i]];
                firstProb = (1.0 - this.bkgCoefficient) * arrFirstScore[i] + this.arrBkgModel[arrFirstIndex[i]];
                distance += firstProb * Math.log(firstProb / secondProb);
                ++i;
lbl18:
                // 2 sources

            } while (i < firstCount);
        }
        if (this.norm) {
            if (distance >= this.normThreshold) {
                return 1.0;
            }
            return distance / this.normThreshold;
        }
        return distance;
    }
}

