/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.docdistance;

import dragon.ir.clustering.docdistance.AbstractDocDistance;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class EuclideanDocDistance
extends AbstractDocDistance {
    public EuclideanDocDistance(SparseMatrix doctermMatrix) {
        super(doctermMatrix);
    }

    public double getDistance(IRDoc first, IRDoc second) {
        double[] firstScoreList = this.matrix.getNonZeroDoubleScoresInRow(first.getIndex());
        double[] secondScoreList = this.matrix.getNonZeroDoubleScoresInRow(second.getIndex());
        int[] firstIndexList = this.matrix.getNonZeroColumnsInRow(first.getIndex());
        int[] secondIndexList = this.matrix.getNonZeroColumnsInRow(second.getIndex());
        int firstNum = firstScoreList.length;
        int secondNum = secondScoreList.length;
        int x2 = 0;
        int y = 0;
        double sum2 = 0.0;
        while (x2 < firstNum && y < secondNum) {
            if (firstIndexList[x2] < secondIndexList[y]) {
                if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x2]) >= 0) {
                    sum2 += firstScoreList[x2] * firstScoreList[x2];
                }
                ++x2;
                continue;
            }
            if (firstIndexList[x2] == secondIndexList[y]) {
                if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x2]) >= 0) {
                    sum2 += (firstScoreList[x2] - secondScoreList[y]) * (firstScoreList[x2] - secondScoreList[y]);
                }
                ++x2;
                ++y;
                continue;
            }
            if (this.featureFilter == null || this.featureFilter.map(secondIndexList[y]) >= 0) {
                sum2 += secondScoreList[y] * secondScoreList[y];
            }
            ++y;
        }
        while (x2 < firstNum) {
            if (this.featureFilter == null || this.featureFilter.map(firstIndexList[x2]) >= 0) {
                sum2 += firstScoreList[x2] * firstScoreList[x2];
            }
            ++x2;
        }
        while (y < secondNum) {
            if (this.featureFilter == null || this.featureFilter.map(secondIndexList[y]) >= 0) {
                sum2 += secondScoreList[y] * secondScoreList[y];
            }
            ++y;
        }
        return Math.sqrt(sum2);
    }
}

