/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.clustermodel;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.clustermodel.AbstractClusterModel;
import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.matrix.DoubleSparseMatrix;
import dragon.util.MathUtil;

public class MultinomialClusterModel
extends AbstractClusterModel {
    private static final int SMOOTH_LAPLACIAN = 0;
    private static final int SMOOTH_BKG = 1;
    private static final int SMOOTH_TRANS = 2;
    private IndexReader indexReader;
    private IndexReader topicIndexReader;
    private DoubleSparseMatrix topicTransMatrix;
    private double[][] arrClusterModel;
    private double[] arrBkgModel;
    private double bkgCoefficient;
    private double transCoefficient;
    private int[] topicMap;
    private int[] termMap;
    private int featureNum;
    private int smoothingMethod;

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.smoothingMethod = 0;
        this.featureNum = indexReader.getCollection().getTermNum();
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, double bkgCoefficient) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 1;
        this.featureNum = indexReader.getCollection().getTermNum();
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, IndexReader topicIndexReader, DoubleSparseMatrix topicTransMatrix, double transCoefficient, double bkgCoefficient) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.topicIndexReader = topicIndexReader;
        this.topicTransMatrix = topicTransMatrix;
        this.transCoefficient = transCoefficient;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 2;
        this.featureNum = indexReader.getCollection().getTermNum();
        this.topicMap = new int[topicIndexReader.getCollection().getTermNum()];
        int i = 0;
        while (i < this.topicMap.length) {
            this.topicMap[i] = i;
            ++i;
        }
        this.termMap = new int[indexReader.getCollection().getTermNum()];
        int i2 = 0;
        while (i2 < this.termMap.length) {
            this.termMap[i2] = i2;
            ++i2;
        }
    }

    public MultinomialClusterModel(int clusterNum, IndexReader indexReader, IndexReader topicIndexReader, KnowledgeBase kngBase, double transCoefficient, double bkgCoefficient) {
        super(clusterNum);
        this.indexReader = indexReader;
        this.topicIndexReader = topicIndexReader;
        this.topicTransMatrix = kngBase.getKnowledgeMatrix();
        this.transCoefficient = transCoefficient;
        this.bkgCoefficient = bkgCoefficient;
        this.smoothingMethod = 2;
        this.featureNum = indexReader.getCollection().getTermNum();
        this.topicMap = new int[topicIndexReader.getCollection().getTermNum()];
        int i = 0;
        while (i < this.topicMap.length) {
            this.topicMap[i] = kngBase.getRowKeyList().search(topicIndexReader.getTermKey(i));
            ++i;
        }
        this.termMap = new int[kngBase.getColumnKeyList().size()];
        i = 0;
        while (i < this.termMap.length) {
            IRTerm curTerm = indexReader.getIRTerm(kngBase.getColumnKeyList().search(i));
            this.termMap[i] = curTerm == null ? -1 : curTerm.getIndex();
            ++i;
        }
    }

    public double getTranslationCoefficient() {
        return this.transCoefficient;
    }

    public void setTranslationCoefficient(double transCoefficient) {
        this.transCoefficient = transCoefficient;
    }

    public double getBackgroundCoefficient() {
        return this.bkgCoefficient;
    }

    public void setBackgroundCoefficient(double bkgCoefficient) {
        this.bkgCoefficient = bkgCoefficient;
    }

    public void setFeatureFilter(FeatureFilter featureFilter) {
        this.featureFilter = featureFilter;
        this.featureNum = featureFilter != null ? featureFilter.getSelectedFeatureNum() : this.indexReader.getCollection().getTermNum();
    }

    public double getDistance(IRDoc doc, int clusterID) {
        int[] arrIndex = this.indexReader.getTermIndexList(doc.getIndex());
        int[] arrFreq = this.indexReader.getTermFrequencyList(doc.getIndex());
        int len = arrIndex == null ? 0 : arrIndex.length;
        double sum2 = 0.0;
        int i = 0;
        while (i < len) {
            int newIndex = this.featureFilter == null ? arrIndex[i] : this.featureFilter.map(arrIndex[i]);
            if (newIndex >= 0) {
                sum2 += (double)arrFreq[i] * this.arrClusterModel[clusterID][newIndex];
            }
            ++i;
        }
        return -sum2;
    }

    public void setClusterNum(int clusterNum) {
        this.clusterNum = clusterNum;
    }

    public void setDocCluster(DocCluster cluster) {
        if (this.arrClusterModel == null || this.arrClusterModel.length != this.clusterNum || this.arrClusterModel[0].length != this.featureNum) {
            this.arrClusterModel = new double[this.clusterNum][this.featureNum];
        }
        int[] arrCount = new int[this.featureNum];
        int i = 0;
        while (i < cluster.getDocNum()) {
            IRDoc curDoc = cluster.getDoc(i);
            int[] arrIndex = this.indexReader.getTermIndexList(curDoc.getIndex());
            int[] arrFreq = this.indexReader.getTermFrequencyList(curDoc.getIndex());
            int len = arrIndex == null ? 0 : arrIndex.length;
            int j = 0;
            while (j < len) {
                int newIndex = this.featureFilter == null ? arrIndex[j] : this.featureFilter.map(arrIndex[j]);
                if (newIndex >= 0) {
                    int n = newIndex;
                    arrCount[n] = arrCount[n] + arrFreq[j];
                }
                ++j;
            }
            ++i;
        }
        if (this.smoothingMethod == 0) {
            this.laplacianSmoothing(arrCount, cluster.getClusterID());
        } else if (this.smoothingMethod == 1) {
            this.backgroundSmoothing(arrCount, cluster.getClusterID());
        } else {
            this.translationSmoothing(arrCount, this.computeTranslationModel(cluster), cluster.getClusterID());
        }
    }

    private void translationSmoothing(int[] arrCount, double[] arrTransModel, int clusterID) {
        if (this.arrBkgModel == null || this.arrBkgModel.length != this.featureNum) {
            this.arrBkgModel = this.getBackgroundModel(this.indexReader);
        }
        double sum2 = this.getSummation(arrCount);
        double a = this.transCoefficient;
        double b = (1.0 - this.bkgCoefficient) * (1.0 - this.transCoefficient) / sum2;
        double c = this.bkgCoefficient * (1.0 - this.transCoefficient);
        int i = 0;
        while (i < this.featureNum) {
            this.arrClusterModel[clusterID][i] = Math.log(arrTransModel[i] * a + (double)arrCount[i] * b + this.arrBkgModel[i] * c);
            ++i;
        }
    }

    private double[] computeTranslationModel(DocCluster cluster) {
        int termIndex;
        int topicIndex;
        int j;
        int[] arrIndex;
        int topicNum = this.topicIndexReader.getCollection().getTermNum();
        int[] arrCount = new int[topicNum];
        int termNum = this.indexReader.getCollection().getTermNum();
        int docNum = this.topicIndexReader.getCollection().getDocNum();
        int i = 0;
        while (i < cluster.getDocNum()) {
            IRDoc curDoc = cluster.getDoc(i);
            if (curDoc.getIndex() < docNum) {
                arrIndex = this.topicIndexReader.getTermIndexList(curDoc.getIndex());
                int[] arrFreq = this.topicIndexReader.getTermFrequencyList(curDoc.getIndex());
                if (arrIndex != null) {
                    j = 0;
                    while (j < arrIndex.length) {
                        int n = arrIndex[j];
                        arrCount[n] = arrCount[n] + arrFreq[j];
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.topicMap.length) {
            topicIndex = this.topicMap[i];
            if (topicIndex < 0) {
                arrCount[i] = 0;
            } else if (topicIndex >= this.topicTransMatrix.rows()) {
                arrCount[i] = 0;
            } else if (this.topicTransMatrix.getNonZeroNumInRow(topicIndex) <= 0) {
                arrCount[i] = 0;
            }
            ++i;
        }
        double sum2 = MathUtil.sumArray(arrCount);
        double[] arrModel = new double[termNum];
        i = 0;
        while (i < topicNum) {
            if (arrCount[i] > 0) {
                topicIndex = this.topicMap[i];
                double rate = (double)arrCount[i] / sum2;
                arrIndex = this.topicTransMatrix.getNonZeroColumnsInRow(topicIndex);
                double[] arrScore = this.topicTransMatrix.getNonZeroDoubleScoresInRow(topicIndex);
                j = 0;
                while (j < arrIndex.length) {
                    termIndex = this.termMap[arrIndex[j]];
                    if (termIndex >= 0) {
                        int n = termIndex;
                        arrModel[n] = arrModel[n] + rate * arrScore[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (arrModel.length == this.featureFilter.getSelectedFeatureNum()) {
            return arrModel;
        }
        double[] arrSelectedModel = new double[this.featureFilter.getSelectedFeatureNum()];
        sum2 = 0.0;
        i = 0;
        while (i < arrModel.length) {
            termIndex = this.featureFilter.map(i);
            if (termIndex >= 0) {
                sum2 += arrModel[i];
                arrSelectedModel[termIndex] = arrModel[i];
            }
            ++i;
        }
        i = 0;
        while (i < arrSelectedModel.length) {
            arrSelectedModel[i] = arrSelectedModel[i] / sum2;
            ++i;
        }
        return arrSelectedModel;
    }

    private void backgroundSmoothing(int[] arrCount, int clusterID) {
        if (this.arrBkgModel == null || this.arrBkgModel.length != this.featureNum) {
            this.arrBkgModel = this.getBackgroundModel(this.indexReader);
        }
        double sum2 = this.getSummation(arrCount);
        int i = 0;
        while (i < this.featureNum) {
            this.arrClusterModel[clusterID][i] = Math.log((double)arrCount[i] / sum2 * (1.0 - this.bkgCoefficient) + this.bkgCoefficient * this.arrBkgModel[i]);
            ++i;
        }
    }

    private void laplacianSmoothing(int[] arrCount, int clusterID) {
        double sum2 = this.getSummation(arrCount) + (double)this.featureNum;
        int i = 0;
        while (i < this.featureNum) {
            this.arrClusterModel[clusterID][i] = Math.log(((double)arrCount[i] + 1.0) / sum2);
            ++i;
        }
    }

    private double getSummation(int[] arrCount) {
        long sum2 = 0L;
        int i = 0;
        while (i < arrCount.length) {
            sum2 += (long)arrCount[i];
            ++i;
        }
        return sum2;
    }

    private double[] getBackgroundModel(IndexReader reader) {
        int termNum = reader.getCollection().getTermNum();
        double sum2 = 0.0;
        double[] arrModel = new double[this.featureNum];
        int i = 0;
        while (i < termNum) {
            int newIndex = this.featureFilter == null ? i : this.featureFilter.map(i);
            if (newIndex >= 0) {
                arrModel[newIndex] = reader.getIRTerm(i).getFrequency();
                sum2 += arrModel[newIndex];
            }
            ++i;
        }
        i = 0;
        while (i < this.featureNum) {
            arrModel[i] = arrModel[i] / sum2;
            ++i;
        }
        return arrModel;
    }
}

