/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering.clustermodel;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.clustermodel.AbstractClusterModel;
import dragon.ir.index.IRDoc;
import dragon.matrix.SparseMatrix;

public class CosineClusterModel
extends AbstractClusterModel {
    private double[][] arrClusterVector;
    private double[] arrClusterVectorLen;
    private SparseMatrix matrix;

    public CosineClusterModel(int clusterNum, SparseMatrix doctermMatrix) {
        super(clusterNum);
        this.matrix = doctermMatrix;
        this.arrClusterVectorLen = new double[clusterNum];
    }

    public void setClusterNum(int clusterNum) {
        this.clusterNum = clusterNum;
        this.arrClusterVectorLen = new double[clusterNum];
    }

    public void setDocCluster(DocCluster cluster) {
        int featureNum = this.featureFilter == null ? this.matrix.columns() : this.featureFilter.getSelectedFeatureNum();
        if (this.arrClusterVector == null || this.arrClusterVector.length != this.clusterNum || this.arrClusterVector[0].length != featureNum) {
            this.arrClusterVector = new double[this.clusterNum][featureNum];
        }
        int clusterID = cluster.getClusterID();
        double vectorLength = 0.0;
        int i = 0;
        while (i < cluster.getDocNum()) {
            int[] indexList = this.matrix.getNonZeroColumnsInRow(cluster.getDoc(i).getIndex());
            double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(cluster.getDoc(i).getIndex());
            int j = 0;
            while (j < indexList.length) {
                int newIndex = indexList[j];
                if (this.featureFilter != null) {
                    newIndex = this.featureFilter.map(newIndex);
                }
                if (newIndex >= 0) {
                    double[] dArray = this.arrClusterVector[clusterID];
                    int n = newIndex;
                    dArray[n] = dArray[n] + freqList[j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.arrClusterVector[clusterID].length) {
            if (this.arrClusterVector[clusterID][i] != 0.0) {
                this.arrClusterVector[clusterID][i] = this.arrClusterVector[clusterID][i] / (double)cluster.getDocNum();
                vectorLength += this.arrClusterVector[clusterID][i] * this.arrClusterVector[clusterID][i];
            }
            ++i;
        }
        this.arrClusterVectorLen[clusterID] = Math.sqrt(vectorLength);
    }

    public double getDistance(IRDoc doc, int clusterID) {
        double product2 = 0.0;
        double docLength = 0.0;
        int[] indexList = this.matrix.getNonZeroColumnsInRow(doc.getIndex());
        double[] freqList = this.matrix.getNonZeroDoubleScoresInRow(doc.getIndex());
        int i = 0;
        while (i < indexList.length) {
            int newIndex = indexList[i];
            if (this.featureFilter != null) {
                newIndex = this.featureFilter.map(newIndex);
            }
            if (newIndex >= 0) {
                product2 += this.arrClusterVector[clusterID][newIndex] * freqList[i];
                docLength += freqList[i] * freqList[i];
            }
            ++i;
        }
        if ((docLength = Math.sqrt(docLength)) == 0.0 || this.arrClusterVectorLen[clusterID] == 0.0) {
            return 1.0;
        }
        return 1.0 - product2 / this.arrClusterVectorLen[clusterID] / docLength;
    }
}

