/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.docdistance.DocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import java.util.Date;

public class HierClustering
extends AbstractClustering {
    public static final int SINGLE_LINKAGE = -1;
    public static final int AVERAGE_LINKAGE = 0;
    public static final int COMPLETE_LINKAGE = 1;
    private DocDistance distMetric;
    private double[][] ccDist;
    private int linkage;

    public HierClustering(IndexReader indexReader, DocDistance distMetric, int clusterNum, int linkage) {
        super(indexReader);
        this.distMetric = distMetric;
        this.clusterNum = clusterNum;
        this.linkage = linkage;
    }

    public boolean cluster(IRDoc[] arrDoc) {
        int j;
        if (this.featureFilter != null) {
            this.featureFilter.initialize(this.indexReader, arrDoc);
            this.distMetric.setFeatureFilter(this.featureFilter);
        }
        if (this.showProgress) {
            System.out.println(new Date() + " Computing the pairwise document similarity...");
        }
        this.clusterSet = new DocClusterSet(arrDoc.length);
        this.ccDist = new double[arrDoc.length][arrDoc.length];
        int i = 0;
        while (i < arrDoc.length) {
            this.clusterSet.addDoc(i, arrDoc[i]);
            this.ccDist[i][i] = 0.0;
            j = i + 1;
            while (j < arrDoc.length) {
                this.ccDist[i][j] = Math.min(this.distMetric.getDistance(arrDoc[i], arrDoc[j]), this.distMetric.getDistance(arrDoc[j], arrDoc[i]));
                this.ccDist[j][i] = this.ccDist[i][j];
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k + this.clusterNum < arrDoc.length) {
            if (this.showProgress && k++ % 100 == 0) {
                System.out.println(new Date() + " " + (arrDoc.length - k));
            }
            double min2 = Double.MAX_VALUE;
            int indexI = -1;
            int indexJ = -1;
            i = 0;
            while (i < arrDoc.length) {
                if (this.ccDist[i][0] != -1.0) {
                    j = 0;
                    while (j < arrDoc.length) {
                        if (i != j && this.ccDist[i][j] != -1.0 && min2 > this.ccDist[i][j]) {
                            min2 = this.ccDist[i][j];
                            indexI = i;
                            indexJ = j;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.mergeCluster(this.clusterSet.getDocCluster(indexI), this.clusterSet.getDocCluster(indexJ));
        }
        DocClusterSet newClusterSet = new DocClusterSet(this.clusterNum);
        j = 0;
        i = 0;
        while (i < this.clusterSet.getClusterNum()) {
            if (this.clusterSet.getDocCluster(i).getDocNum() != 0) {
                newClusterSet.setDocCluster(this.clusterSet.getDocCluster(i), j++);
            }
            ++i;
        }
        this.clusterSet = newClusterSet;
        return true;
    }

    private void mergeCluster(DocCluster mergingCluster, DocCluster deletingCluster) {
        int curMerging = mergingCluster.getClusterID();
        int curDeleting = deletingCluster.getClusterID();
        int i = 0;
        while (i < this.clusterSet.getClusterNum()) {
            if (i != curMerging && i != curDeleting && this.clusterSet.getDocCluster(i).getDocNum() != 0) {
                this.ccDist[curMerging][i] = this.getDistance(mergingCluster, deletingCluster, i, this.linkage);
                this.ccDist[i][curMerging] = this.ccDist[curMerging][i];
            }
            ++i;
        }
        i = 0;
        while (i < this.clusterSet.getClusterNum()) {
            this.ccDist[curDeleting][i] = -1.0;
            this.ccDist[i][curDeleting] = -1.0;
            ++i;
        }
        i = 0;
        while (i < deletingCluster.getDocNum()) {
            mergingCluster.addDoc(deletingCluster.getDoc(i));
            ++i;
        }
        deletingCluster.removeAll();
    }

    private double getDistance(DocCluster mergingCluster, DocCluster deletingCluster, int clusterID, int linkage) {
        int curMerging = mergingCluster.getClusterID();
        int curDeleting = deletingCluster.getClusterID();
        if (linkage == -1) {
            return Math.min(this.ccDist[curMerging][clusterID], this.ccDist[curDeleting][clusterID]);
        }
        if (linkage == 1) {
            return Math.max(this.ccDist[curMerging][clusterID], this.ccDist[curDeleting][clusterID]);
        }
        return (this.ccDist[curMerging][clusterID] * (double)mergingCluster.getDocNum() + this.ccDist[curDeleting][clusterID] * (double)deletingCluster.getDocNum()) / (double)(mergingCluster.getDocNum() + deletingCluster.getDocNum());
    }
}

