/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;

public class ClusteringEva {
    private double entropyScore;
    private double fScore;
    private double purityScore;
    private double nmiScore;
    private double geoNmiScore;
    private double miScore;
    private DocClusterSet human;
    private DocClusterSet machine;
    private double[][] matchMatrix;
    private double[][] recallMatrix;
    private double[][] precMatrix;
    private double docSum;
    private int clusterNum;
    private int classNum;

    public boolean evaluate(DocClusterSet machine, DocClusterSet human) {
        this.human = this.preprocessDocClusterSet(human);
        this.machine = this.preprocessDocClusterSet(machine);
        this.stat();
        this.matchMatrix = this.compClassMatch();
        this.compPrecRecall();
        this.compEntropy();
        this.compFScore();
        this.compPurityScore();
        this.compNMI();
        return true;
    }

    public double[][] getMatchMatrix() {
        return this.matchMatrix;
    }

    public double getMI() {
        return this.miScore;
    }

    public double getEntropy() {
        return this.entropyScore;
    }

    public double getFScore() {
        return this.fScore;
    }

    public double getPurity() {
        return this.purityScore;
    }

    public double getGeometryNMI() {
        return this.geoNmiScore;
    }

    public double getNMI() {
        return this.nmiScore;
    }

    private void stat() {
        int docSum = 0;
        int i = 0;
        while (i < this.machine.getClusterNum()) {
            docSum += this.machine.getDocCluster(i).getDocNum();
            ++i;
        }
        this.docSum = docSum;
        this.clusterNum = this.machine.getClusterNum();
        this.classNum = this.machine.getClusterNum();
    }

    private void compFScore() {
        double max2 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.recallMatrix.length) {
            max2 = 0.0;
            int j = 0;
            while (j < this.recallMatrix[0].length) {
                if (max2 < this.compFScore(i, j)) {
                    max2 = this.compFScore(i, j);
                }
                ++j;
            }
            sum2 += (double)this.human.getDocCluster(i).getDocNum() / this.docSum * max2;
            ++i;
        }
        this.fScore = sum2;
    }

    private double compFScore(int i, int j) {
        if (this.recallMatrix[i][j] == 0.0 && this.recallMatrix[i][j] == 0.0) {
            return 0.0;
        }
        return 2.0 * this.recallMatrix[i][j] * this.precMatrix[i][j] / (this.precMatrix[i][j] + this.recallMatrix[i][j]);
    }

    private void compPurityScore() {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.machine.getClusterNum()) {
            sum2 += this.compPurityScore(this.machine.getDocCluster(i).getClusterID()) * ((double)this.machine.getDocCluster(i).getDocNum() / this.docSum);
            ++i;
        }
        this.purityScore = sum2;
    }

    private double compPurityScore(int clusterID) {
        if (this.machine.getDocCluster(clusterID).getDocNum() == 0) {
            return 0.0;
        }
        double max2 = Double.MIN_VALUE;
        int i = 0;
        while (i < this.classNum) {
            if (max2 < this.matchMatrix[clusterID][i]) {
                max2 = this.matchMatrix[clusterID][i];
            }
            ++i;
        }
        return max2 / (double)this.machine.getDocCluster(clusterID).getDocNum();
    }

    private void compEntropy() {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.clusterNum) {
            sum2 += (double)this.machine.getDocCluster(i).getDocNum() * this.compEntropy(i) / this.docSum;
            ++i;
        }
        this.entropyScore = sum2;
    }

    private double compEntropy(int clusterID) {
        double sum2 = 0.0;
        int j = 0;
        while (j < this.clusterNum) {
            sum2 = this.precMatrix[clusterID][j] == 0.0 ? (sum2 += -Math.log(1.0 / this.docSum) * (1.0 / this.docSum)) : (sum2 += -Math.log(this.precMatrix[clusterID][j]) * this.precMatrix[clusterID][j]);
            ++j;
        }
        return sum2;
    }

    private double[][] compClassMatch() {
        double[][] match = new double[this.clusterNum][this.classNum];
        int i = 0;
        while (i < this.clusterNum) {
            DocCluster dc1 = this.machine.getDocCluster(i);
            int j = 0;
            while (j < this.classNum) {
                DocCluster dc2 = this.human.getDocCluster(j);
                int k = 0;
                while (k < dc2.getDocNum()) {
                    if (dc1.containDoc(dc2.getDoc(k))) {
                        double[] dArray = match[i];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return match;
    }

    private void compPrecRecall() {
        this.precMatrix = new double[this.matchMatrix.length][this.matchMatrix[0].length];
        this.recallMatrix = new double[this.matchMatrix.length][this.matchMatrix[0].length];
        int i = 0;
        while (i < this.clusterNum) {
            DocCluster dc1 = this.machine.getDocCluster(i);
            int j = 0;
            while (j < this.classNum) {
                DocCluster dc2 = this.human.getDocCluster(j);
                this.precMatrix[i][j] = this.matchMatrix[i][j] / (double)dc1.getDocNum();
                this.recallMatrix[i][j] = this.matchMatrix[i][j] / (double)dc2.getDocNum();
                ++j;
            }
            ++i;
        }
    }

    private void compNMI() {
        double yProb;
        double xProb;
        double sumJoint = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        int i = 0;
        while (i < this.clusterNum) {
            int j = 0;
            while (j < this.classNum) {
                double jointProb = this.matchMatrix[i][j] == 0.0 ? 1.0 / this.docSum : this.matchMatrix[i][j] / this.docSum;
                xProb = (double)this.machine.getDocCluster(i).getDocNum() / this.docSum;
                yProb = (double)this.human.getDocCluster(j).getDocNum() / this.docSum;
                sumJoint += jointProb * Math.log(jointProb / (xProb * yProb));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.clusterNum) {
            xProb = (double)this.machine.getDocCluster(i).getDocNum() / this.docSum;
            sumX += xProb * Math.log(1.0 / xProb);
            ++i;
        }
        i = 0;
        while (i < this.clusterNum) {
            yProb = (double)this.human.getDocCluster(i).getDocNum() / this.docSum;
            sumY += yProb * Math.log(1.0 / yProb);
            ++i;
        }
        this.miScore = sumJoint;
        this.nmiScore = 2.0 * sumJoint / (Math.log(this.clusterNum) + Math.log(this.classNum));
        this.geoNmiScore = sumJoint / Math.sqrt(sumX * sumY);
    }

    private DocClusterSet preprocessDocClusterSet(DocClusterSet oldSet) {
        int count2 = 0;
        int i = 0;
        while (i < oldSet.getClusterNum()) {
            if (oldSet.getDocCluster(i).getDocNum() > 0) {
                ++count2;
            }
            ++i;
        }
        DocClusterSet newSet = new DocClusterSet(count2);
        count2 = 0;
        i = 0;
        while (i < oldSet.getClusterNum()) {
            if (oldSet.getDocCluster(i).getDocNum() > 0) {
                newSet.setDocCluster(oldSet.getDocCluster(i), count2);
                ++count2;
            }
            ++i;
        }
        return newSet;
    }
}

