/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;

public abstract class AbstractClustering
implements Clustering {
    protected IndexReader indexReader;
    protected FeatureFilter featureFilter;
    protected int clusterNum;
    protected DocClusterSet clusterSet;
    protected boolean showProgress;
    protected long randomSeed;

    public AbstractClustering(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.showProgress = true;
    }

    public int getClusterNum() {
        return this.clusterNum;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(long seed) {
        this.randomSeed = seed;
    }

    public DocClusterSet getClusterSet() {
        return this.clusterSet;
    }

    public DocCluster getCluster(int index) {
        return this.clusterSet.getDocCluster(index);
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public boolean cluster() {
        IRDoc[] arrDoc = new IRDoc[this.indexReader.getCollection().getDocNum()];
        int i = 0;
        while (i < arrDoc.length) {
            arrDoc[i] = this.indexReader.getDoc(i);
            ++i;
        }
        return this.cluster(arrDoc);
    }

    public FeatureFilter getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(FeatureFilter selector) {
        this.featureFilter = selector;
    }

    public void setShowProgress(boolean option) {
        this.showProgress = option;
    }
}

