/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification.featureselection;

import dragon.ir.classification.DocClassSet;
import dragon.ir.classification.featureselection.AbstractFeatureSelector;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.matrix.IntDenseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;
import java.util.ArrayList;

public class DocFrequencySelector
extends AbstractFeatureSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int minDocFrequency;

    public DocFrequencySelector(int minDocFrequency) {
        this.minDocFrequency = minDocFrequency;
    }

    protected int[] getSelectedFeatures(SparseMatrix doctermMatrix, DocClassSet trainingSet) {
        int[] featureMap = this.getTermDocFrequency(doctermMatrix, trainingSet);
        int termNum = featureMap.length;
        ArrayList<Integer> list2 = new ArrayList<Integer>(termNum);
        int i = 0;
        while (i < termNum) {
            if (featureMap[i] >= this.minDocFrequency) {
                list2.add(new Integer(i));
            }
            ++i;
        }
        featureMap = new int[list2.size()];
        i = 0;
        while (i < featureMap.length) {
            featureMap[i] = (Integer)list2.get(i);
            ++i;
        }
        return featureMap;
    }

    protected int[] getSelectedFeatures(IndexReader indexReader, DocClassSet trainingSet) {
        IntDenseMatrix termDistri = this.getTermDistribution(indexReader, trainingSet);
        int termNum = termDistri.columns();
        ArrayList<IRTerm> list2 = new ArrayList<IRTerm>(termNum);
        int i = 0;
        while (i < termNum) {
            IRTerm curTerm;
            if (termDistri.getColumnSum(i) > 0L && (curTerm = indexReader.getIRTerm(i)).getDocFrequency() >= this.minDocFrequency) {
                list2.add(curTerm);
            }
            ++i;
        }
        int[] featureMap = new int[list2.size()];
        i = 0;
        while (i < featureMap.length) {
            featureMap[i] = ((IRTerm)list2.get(i)).getIndex();
            ++i;
        }
        return featureMap;
    }
}

