/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification;

import dragon.ir.classification.DocClass;
import dragon.ir.classification.DocClassSet;
import dragon.ir.index.IRDoc;
import dragon.util.FormatUtil;
import dragon.util.MathUtil;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class ClassificationEva {
    private double[] arrPrecision;
    private double[] arrRecall;
    private double[] arrF1;
    private double[] arrPn;
    private double precision;
    private double recall;
    private double f1;
    private double mrr;

    public boolean evaluate(int classNum, int[] human, int[][] machine) {
        if (human.length != machine.length) {
            return false;
        }
        this.mrr = 0.0;
        int count2 = 0;
        this.arrPn = new double[classNum];
        DocClassSet humanSet = new DocClassSet(classNum);
        DocClassSet machineSet = new DocClassSet(classNum);
        int i = 0;
        while (i < human.length) {
            humanSet.addDoc(human[i], new IRDoc(i));
            int[] rank = machine[i];
            if (rank != null) {
                machineSet.addDoc(rank[0], new IRDoc(i));
                ++count2;
                int j = 0;
                while (j < classNum && rank[j] != human[i]) {
                    ++j;
                }
                this.mrr += 1.0 / (double)(j + 1);
                while (j < classNum) {
                    int n = j++;
                    this.arrPn[n] = this.arrPn[n] + 1.0;
                }
            }
            ++i;
        }
        this.mrr /= (double)count2;
        i = 0;
        while (i < classNum) {
            this.arrPn[i] = this.arrPn[i] / (double)count2;
            ++i;
        }
        return this.evaluate(humanSet, machineSet);
    }

    public boolean evaluate(DocClassSet human, DocClassSet machine) {
        if (human.getClassNum() != machine.getClassNum()) {
            return false;
        }
        int humanTotal = 0;
        int machineTotal = 0;
        int totalCount = 0;
        this.arrPrecision = new double[human.getClassNum()];
        this.arrRecall = new double[human.getClassNum()];
        this.arrF1 = new double[human.getClassNum()];
        int i = 0;
        while (i < human.getClassNum()) {
            int[] arrResult = this.matchDocs(human.getDocClass(i), machine.getDocClass(i));
            this.arrPrecision[i] = arrResult[1] == 0 ? 0.0 : (double)arrResult[0] / (double)arrResult[1];
            this.arrRecall[i] = arrResult[2] == 0 ? 0.0 : (double)arrResult[0] / (double)arrResult[2];
            this.arrF1[i] = this.arrPrecision[i] == 0.0 || this.arrRecall[i] == 0.0 ? 0.0 : 2.0 * this.arrPrecision[i] * this.arrRecall[i] / (this.arrPrecision[i] + this.arrRecall[i]);
            humanTotal += arrResult[2];
            machineTotal += arrResult[1];
            totalCount += arrResult[0];
            ++i;
        }
        this.precision = (double)totalCount / (double)machineTotal;
        this.recall = (double)totalCount / (double)humanTotal;
        this.f1 = this.precision == 0.0 || this.recall == 0.0 ? 0.0 : 2.0 * this.precision * this.recall / (this.precision + this.recall);
        return true;
    }

    public double getPrecision(int classID) {
        return this.arrPrecision[classID];
    }

    public double getRecall(int classID) {
        return this.arrRecall[classID];
    }

    public double getFscore(int classID) {
        return this.arrF1[classID];
    }

    public double getMicroPrecision() {
        return this.precision;
    }

    public double getMicroRecall() {
        return this.recall;
    }

    public double getMicroFScore() {
        return this.f1;
    }

    public double getMacroPrecision() {
        return MathUtil.average(this.arrPrecision);
    }

    public double getMacroRecall() {
        return MathUtil.average(this.arrRecall);
    }

    public double getMacroFScore() {
        return MathUtil.average(this.arrF1);
    }

    public double getMRR() {
        return this.mrr;
    }

    public double getPrecisionN(int top) {
        if (this.arrPn == null || top >= this.arrPn.length) {
            return 0.0;
        }
        return this.arrPn[top];
    }

    public void print(PrintWriter out) {
        try {
            DecimalFormat df1 = FormatUtil.getNumericFormat(2, 0);
            DecimalFormat df2 = FormatUtil.getNumericFormat(1, 2);
            int i = 0;
            while (i < this.arrPrecision.length) {
                out.write("Class #" + df1.format(i) + ": ");
                out.write(df2.format(this.arrPrecision[i] * 100.0) + "%/" + df2.format(this.arrRecall[i] * 100.0) + "%\n");
                ++i;
            }
            out.write("Overall: ");
            out.write(df2.format(this.precision * 100.0) + "%/" + df2.format(this.recall * 100.0) + "%\n");
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] matchDocs(DocClass human, DocClass machine) {
        int humanNum = human.getDocNum();
        int machineNum = machine.getDocNum();
        int i = 0;
        int j = 0;
        int correct = 0;
        while (i < humanNum && j < machineNum) {
            int machineIndex;
            int humanIndex = human.getDoc(i).getIndex();
            if (humanIndex == (machineIndex = machine.getDoc(j).getIndex())) {
                ++correct;
                ++i;
                ++j;
                continue;
            }
            if (humanIndex < machineIndex) {
                ++i;
                continue;
            }
            ++j;
        }
        int[] arrResult = new int[]{correct, machineNum, humanNum};
        return arrResult;
    }
}

