/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.LemmatiserConfig;
import dragon.nlp.ontology.BasicVocabulary;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;

public class VocabularyConfig
extends ConfigUtil {
    public VocabularyConfig() {
    }

    public VocabularyConfig(ConfigureNode root2) {
        super(root2);
    }

    public VocabularyConfig(String configFile) {
        super(configFile);
    }

    public Vocabulary getVocabulary(int vocabularyID) {
        return this.getVocabulary(this.root, vocabularyID);
    }

    public Vocabulary getVocabulary(ConfigureNode node, int vocabularyID) {
        return this.loadVocabulary(node, vocabularyID);
    }

    private Vocabulary loadVocabulary(ConfigureNode node, int vocabularyID) {
        ConfigureNode vocabularyNode = this.getConfigureNode(node, "vocabulary", vocabularyID);
        if (vocabularyNode == null) {
            return null;
        }
        String vocabularyName = vocabularyNode.getNodeName();
        return this.loadVocabulary(vocabularyName, vocabularyNode);
    }

    protected Vocabulary loadVocabulary(String vocabularyName, ConfigureNode vocabularyNode) {
        if (vocabularyName.equalsIgnoreCase("BasicVocabulary")) {
            return this.loadBasicVocabulary(vocabularyNode);
        }
        return (Vocabulary)this.loadResource(vocabularyNode);
    }

    private Vocabulary loadBasicVocabulary(ConfigureNode curNode) {
        String vobFile = curNode.getString("vobfile");
        int lemmatiserID = curNode.getInt("lemmatiser", 0);
        boolean lemmaOption = curNode.getBoolean("lemmaoption", false);
        boolean nppOption = curNode.getBoolean("nppoption", false);
        boolean coordinateOption = curNode.getBoolean("coordinateoption", false);
        boolean adjtermOption = curNode.getBoolean("adjtermoption", false);
        String nonBoundaryPunc = curNode.getString("nonboundarypunctuation", "");
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(curNode, lemmatiserID);
        BasicVocabulary vocabulary = new BasicVocabulary(vobFile, lemmatiser);
        vocabulary.setLemmaOption(lemmaOption);
        vocabulary.setAdjectivePhraseOption(adjtermOption);
        vocabulary.setCoordinateOption(coordinateOption);
        vocabulary.setNPPOption(nppOption);
        vocabulary.setNonBoundaryPunctuation(nonBoundaryPunc);
        return vocabulary;
    }
}

