/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.index.BasicIndexReader;
import dragon.ir.index.IRCollection;
import dragon.ir.index.IndexReader;
import dragon.ir.search.smooth.DirichletSmoother;
import dragon.ir.search.smooth.DocFirstTransSmoother;
import dragon.ir.search.smooth.JMSmoother;
import dragon.ir.search.smooth.OkapiSmoother;
import dragon.ir.search.smooth.PivotedNormSmoother;
import dragon.ir.search.smooth.QueryFirstTransSmoother;
import dragon.ir.search.smooth.Smoother;
import dragon.ir.search.smooth.TFIDFSmoother;
import dragon.ir.search.smooth.TwoStageSmoother;
import dragon.matrix.DoubleSparseMatrix;

public class SmootherConfig
extends ConfigUtil {
    public SmootherConfig() {
    }

    public SmootherConfig(ConfigureNode root2) {
        super(root2);
    }

    public SmootherConfig(String configFile) {
        super(configFile);
    }

    public Smoother getSmoother(int smootherID) {
        return this.getSmoother(this.root, smootherID);
    }

    public Smoother getSmoother(ConfigureNode node, int smootherID) {
        return this.loadSmoother(node, smootherID);
    }

    private Smoother loadSmoother(ConfigureNode node, int smootherID) {
        ConfigureNode smootherNode = this.getConfigureNode(node, "smoother", smootherID);
        if (smootherNode == null) {
            return null;
        }
        String smootherName = smootherNode.getNodeName();
        return this.loadSmoother(smootherName, smootherNode);
    }

    protected Smoother loadSmoother(String smootherName, ConfigureNode smootherNode) {
        if (smootherName.equalsIgnoreCase("JMSmoother")) {
            return this.loadJMSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("DirichletSmoother")) {
            return this.loadDirichletSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("AbsoluteDiscountSmoother")) {
            return this.loadAbsoluteDiscountSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("TwoStageSmoother")) {
            return this.loadTwoStageSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("OkapiSmoother")) {
            return this.loadOkapiSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("TFIDFSmoother")) {
            return this.loadTFIDFSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("PivotedNormSmoother")) {
            return this.loadPivotedNormSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("QueryFirstTransSmoother")) {
            return this.loadQueryFirstTransSmoother(smootherNode);
        }
        if (smootherName.equalsIgnoreCase("DocFirstTransSmoother")) {
            return this.loadDocFirstTransSmoother(smootherNode);
        }
        return (Smoother)this.loadResource(smootherNode);
    }

    private Smoother loadJMSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        return new JMSmoother(collection, bkgCoefficient);
    }

    private Smoother loadDirichletSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double dirichletCoefficient = node.getDouble("dirichletcoefficient", 1000.0);
        return new DirichletSmoother(collection, dirichletCoefficient);
    }

    private Smoother loadAbsoluteDiscountSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double absoluteDiscount = node.getDouble("absolutediscount", 0.6);
        return new DirichletSmoother(collection, absoluteDiscount);
    }

    private Smoother loadTwoStageSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double dirichletCoefficient = node.getDouble("dirichletcoefficient", 1000.0);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        return new TwoStageSmoother(collection, bkgCoefficient, dirichletCoefficient);
    }

    private Smoother loadPivotedNormSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double s = node.getDouble("s", 0.2);
        return new PivotedNormSmoother(collection, s);
    }

    private Smoother loadOkapiSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        double bm25k1 = node.getDouble("bm25k1", 2.0);
        double bm25b = node.getDouble("bm25b", 0.75);
        return new OkapiSmoother(collection, bm25k1, bm25b);
    }

    private Smoother loadTFIDFSmoother(ConfigureNode node) {
        int collectionStatID = node.getInt("collectionstat");
        IRCollection collection = new IndexReaderConfig().getIRCollectionStat(node, collectionStatID);
        boolean useBM25 = node.getBoolean("usebm25", false);
        if (useBM25) {
            double bm25k1 = node.getDouble("bm25k1", 2.0);
            double bm25b = node.getDouble("bm25b", 0.75);
            return new TFIDFSmoother(collection, bm25k1, bm25b);
        }
        return new TFIDFSmoother(collection);
    }

    private Smoother loadQueryFirstTransSmoother(ConfigureNode node) {
        IndexReaderConfig config = new IndexReaderConfig();
        int srcIndexReaderID = node.getInt("srcindexreader");
        int destIndexReaderID = node.getInt("destindexreader");
        BasicIndexReader srcIndexReader = (BasicIndexReader)config.getIndexReader(node, srcIndexReaderID);
        BasicIndexReader destIndexReader = destIndexReaderID == srcIndexReaderID ? srcIndexReader : (BasicIndexReader)config.getIndexReader(node, destIndexReaderID);
        double transCoefficient = node.getDouble("transcoefficient");
        int matrixID = node.getInt("transposedtransmatrix");
        int smootherID = node.getInt("basicsmoother");
        Smoother basicSmoother = this.getSmoother(node, smootherID);
        DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID);
        if (srcIndexReaderID == destIndexReaderID) {
            boolean relationTrans = node.getBoolean("relationtrans", true);
            return new QueryFirstTransSmoother((IndexReader)srcIndexReader, transMatrix, relationTrans, transCoefficient, basicSmoother);
        }
        return new QueryFirstTransSmoother((IndexReader)srcIndexReader, destIndexReader, transMatrix, transCoefficient, basicSmoother);
    }

    private Smoother loadDocFirstTransSmoother(ConfigureNode node) {
        IndexReaderConfig config = new IndexReaderConfig();
        int srcIndexReaderID = node.getInt("srcindexreader");
        int destIndexReaderID = node.getInt("destindexreader");
        IndexReader srcIndexReader = config.getIndexReader(node, srcIndexReaderID);
        IndexReader destIndexReader = destIndexReaderID == srcIndexReaderID ? srcIndexReader : config.getIndexReader(node, destIndexReaderID);
        double transCoefficient = node.getDouble("transcoefficient");
        int matrixID = node.getInt("transmatrix");
        int smootherID = node.getInt("basicsmoother");
        Smoother basicSmoother = this.getSmoother(node, smootherID);
        DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID);
        if (srcIndexReaderID == destIndexReaderID) {
            boolean relationTrans = node.getBoolean("relationtrans", true);
            return new DocFirstTransSmoother(srcIndexReader, transMatrix, relationTrans, transCoefficient, basicSmoother);
        }
        return new QueryFirstTransSmoother(srcIndexReader, destIndexReader, transMatrix, transCoefficient, basicSmoother);
    }
}

