/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SearcherConfig;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.search.Searcher;
import dragon.ir.search.evaluate.TrecEva;
import dragon.nlp.SimpleElement;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeMap;

public class RetrievalEvaAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and retrieval evaluation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode retrievalAppNode = util.getConfigureNode(root2, "retrievalevaapp", Integer.parseInt(args[1]));
        if (retrievalAppNode == null) {
            return;
        }
        RetrievalEvaAppConfig retrievalApp = new RetrievalEvaAppConfig();
        retrievalApp.evaluate(retrievalAppNode);
    }

    public void evaluate(ConfigureNode node) {
        ArrayList<Integer> excludedQueries;
        SearcherConfig config = new SearcherConfig();
        int searcherID = node.getInt("searcher", 0);
        if (searcherID <= 0) {
            return;
        }
        Searcher searcher = config.getSearcher(node, searcherID);
        String judgmentFile = node.getString("judgmentfile", null);
        String queryFile = node.getString("queryfile", null);
        String resultFolder = node.getString("resultfolder", null);
        if (judgmentFile == null || queryFile == null || resultFolder == null) {
            return;
        }
        int start = node.getInt("startopic", -1);
        int end = node.getInt("endtopic", -1);
        String excludedTopics = node.getString("excludedtopics", null);
        if (excludedTopics == null || excludedTopics.trim().length() == 0) {
            excludedQueries = null;
        } else {
            String[] arrTopic = excludedTopics.trim().split(";");
            excludedQueries = new ArrayList<Integer>(arrTopic.length);
            int i = 0;
            while (i < arrTopic.length) {
                excludedQueries.add(new Integer(arrTopic[i]));
                ++i;
            }
        }
        this.evaluate(searcher, judgmentFile, queryFile, resultFolder, start, end, excludedQueries);
    }

    public void evaluate(Searcher searcher, String judgmentFile, String queryFile, String outputFolder, int start, int end, ArrayList excludedQueries) {
        try {
            new File(outputFolder).mkdirs();
            SimpleElement[] arrQuery = this.readQuery(queryFile);
            TreeMap arrRelevant = this.loadJudgmentFile(searcher.getIndexReader(), judgmentFile);
            TrecEva eva = new TrecEva(outputFolder);
            double[] resultSum = new double[10];
            int i = 0;
            while (i < 10) {
                resultSum[i] = 0.0;
                ++i;
            }
            DecimalFormat df = FormatUtil.getNumericFormat(2, 2);
            int total = 0;
            PrintWriter out = FileUtil.getPrintWriter(outputFolder + "/all.eva");
            out.write("Query\tRetrieved\tRelevant\tP@10\tR@10\tP@100\tR@100\tP\tR\tAP\r\n");
            i = 0;
            while (i < arrQuery.length) {
                ArrayList list2;
                int queryNo = arrQuery[i].getIndex();
                if (!(queryNo < start && start >= 0 || queryNo > end && end >= 0 || (list2 = (ArrayList)arrRelevant.get(new Integer(queryNo))) == null || list2.size() == 0 || excludedQueries != null && excludedQueries.contains(new Integer(queryNo)))) {
                    ++total;
                    System.out.print("Processing Query #" + queryNo);
                    RelSimpleQuery irQuery = new RelSimpleQuery(arrQuery[i].getKey());
                    irQuery.setQueryKey(queryNo);
                    searcher.search(irQuery);
                    double[] result2 = eva.evaluateQuery(irQuery, searcher.getRankedDocumentList(), list2, searcher.getIndexReader());
                    this.printEvaStat(result2, out);
                    System.out.print(" " + df.format(result2[9]) + "%\n");
                    int j = 0;
                    while (j < 10) {
                        int n = j;
                        resultSum[n] = resultSum[n] + result2[j];
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < 10) {
                resultSum[i] = resultSum[i] / (double)total;
                ++i;
            }
            System.out.println("MAP:  " + df.format(resultSum[9]) + "%");
            System.out.println("P@10: " + df.format(resultSum[3]) + "%");
            System.out.println("P@100:" + df.format(resultSum[5]) + "%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printEvaStat(double[] result2, PrintWriter out) {
        try {
            DecimalFormat df = FormatUtil.getNumericFormat(2, 2);
            DecimalFormat dfInteger = FormatUtil.getNumericFormat(0, 0);
            int i = 0;
            while (i < 3) {
                if (i > 0) {
                    out.write(9);
                }
                out.write(dfInteger.format(result2[i]));
                ++i;
            }
            i = 3;
            while (i <= 9) {
                out.write(9);
                out.write(df.format(result2[i]));
                ++i;
            }
            out.write("\r\n");
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SimpleElement[] readQuery(String queryFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(queryFile)));
            String line = br.readLine();
            int total = Integer.parseInt(line);
            SimpleElement[] arrQuery = new SimpleElement[total];
            int count2 = 0;
            while ((line = br.readLine()) != null) {
                int j = line.indexOf(9);
                int lineNo = Integer.parseInt(line.substring(0, j));
                arrQuery[count2] = new SimpleElement(line.substring(j + 1), lineNo);
                ++count2;
            }
            br.close();
            return arrQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap loadJudgmentFile(IndexReader reader, String filename) {
        try {
            String line;
            TreeMap<Integer, ArrayList<IRDoc>> arrRelevant = new TreeMap<Integer, ArrayList<IRDoc>>();
            int count2 = 0;
            BufferedReader br = FileUtil.getTextReader(filename);
            while ((line = br.readLine()) != null) {
                IRDoc cur;
                void var13_13;
                ++count2;
                int start = var13_13.indexOf(9);
                int end = var13_13.indexOf(9, start + 1);
                int topicID = Integer.parseInt(var13_13.substring(0, start));
                String pmid = var13_13.substring(start + 1, end);
                int relevance = Integer.parseInt(var13_13.substring(end + 1));
                if (relevance <= 0 || relevance >= 3 || (cur = reader.getDoc(pmid)) == null) continue;
                ArrayList<IRDoc> list2 = (ArrayList<IRDoc>)arrRelevant.get(new Integer(topicID));
                if (list2 == null) {
                    list2 = new ArrayList<IRDoc>();
                    arrRelevant.put(new Integer(topicID), list2);
                }
                list2.add(cur);
            }
            return arrRelevant;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

