/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.LossFunctionConfig;
import dragon.ir.classification.multiclass.LossMultiClassDecoder;
import dragon.ir.classification.multiclass.MultiClassDecoder;

public class MultiClassDecoderConfig
extends ConfigUtil {
    public MultiClassDecoderConfig() {
    }

    public MultiClassDecoderConfig(ConfigureNode root2) {
        super(root2);
    }

    public MultiClassDecoderConfig(String configFile) {
        super(configFile);
    }

    public MultiClassDecoder getMultiClassDecoder(int decoderID) {
        return this.getMultiClassDecoder(this.root, decoderID);
    }

    public MultiClassDecoder getMultiClassDecoder(ConfigureNode node, int decoderID) {
        return this.loadMultiClassDecoder(node, decoderID);
    }

    private MultiClassDecoder loadMultiClassDecoder(ConfigureNode node, int decoderID) {
        ConfigureNode decoderNode = this.getConfigureNode(node, "MultiClassDecoder", decoderID);
        if (decoderNode == null) {
            return null;
        }
        String decoderName = decoderNode.getNodeName();
        return this.loadMultiClassDecoder(decoderName, decoderNode);
    }

    protected MultiClassDecoder loadMultiClassDecoder(String decoderName, ConfigureNode decoderNode) {
        if (decoderName.equalsIgnoreCase("LossMultiClassDecoder")) {
            return this.loadLossMultiClassDecoder(decoderNode);
        }
        return (MultiClassDecoder)this.loadResource(decoderNode);
    }

    private MultiClassDecoder loadLossMultiClassDecoder(ConfigureNode node) {
        int lossFuncID = node.getInt("lossfunction");
        if (lossFuncID < 1) {
            return null;
        }
        return new LossMultiClassDecoder(new LossFunctionConfig().getLossFunction(node, lossFuncID));
    }
}

