/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.classification.multiclass.HingeLoss;
import dragon.ir.classification.multiclass.LinearLoss;
import dragon.ir.classification.multiclass.LossFunction;

public class LossFunctionConfig
extends ConfigUtil {
    public LossFunctionConfig() {
    }

    public LossFunctionConfig(ConfigureNode root2) {
        super(root2);
    }

    public LossFunctionConfig(String configFile) {
        super(configFile);
    }

    public LossFunction getLossFunction(int lossFuncID) {
        return this.getLossFunction(this.root, lossFuncID);
    }

    public LossFunction getLossFunction(ConfigureNode node, int lossFuncID) {
        return this.loadLossFunction(node, lossFuncID);
    }

    private LossFunction loadLossFunction(ConfigureNode node, int lossFuncID) {
        ConfigureNode lossFuncNode = this.getConfigureNode(node, "LossFunction", lossFuncID);
        if (lossFuncNode == null) {
            return null;
        }
        String lossFuncName = lossFuncNode.getNodeName();
        return this.loadLossFunction(lossFuncName, lossFuncNode);
    }

    protected LossFunction loadLossFunction(String lossFuncName, ConfigureNode lossFuncNode) {
        if (lossFuncName.equalsIgnoreCase("HingeLoss")) {
            return new HingeLoss();
        }
        if (lossFuncName.equalsIgnoreCase("LinearLoss")) {
            return new LinearLoss();
        }
        return (LossFunction)this.loadResource(lossFuncNode);
    }
}

