/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.CollectionReaderConfig;
import dragon.config.ConceptExtractorConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexerConfig;
import dragon.ir.index.BasicIndexReader;
import dragon.ir.index.IRCollection;
import dragon.ir.index.IndexReader;
import dragon.ir.index.OnlineIndexReader;
import dragon.ir.index.OnlineIndexer;
import dragon.ir.index.sentence.BasicSentenceIndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.index.sequence.BasicSequenceIndexReader;
import dragon.ir.index.sequence.OnlineSequenceIndexReader;
import dragon.ir.index.sequence.OnlineSequenceIndexer;
import dragon.nlp.SimpleElementList;
import dragon.nlp.extract.ConceptExtractor;
import dragon.onlinedb.CollectionReader;

public class IndexReaderConfig
extends ConfigUtil {
    public IndexReaderConfig() {
    }

    public IndexReaderConfig(ConfigureNode root2) {
        super(root2);
    }

    public IndexReaderConfig(String configFile) {
        super(configFile);
    }

    public IRCollection getIRCollectionStat(int collectionID) {
        return this.getIRCollectionStat(this.root, collectionID);
    }

    public IRCollection getIRCollectionStat(ConfigureNode node, int collectionID) {
        ConfigureNode collectionNode = this.getConfigureNode(node, "collectionstat", collectionID);
        if (collectionNode == null) {
            return null;
        }
        String collectionName = collectionNode.getNodeName();
        if (!collectionName.equalsIgnoreCase("IRCollection")) {
            return null;
        }
        String indexFolder = collectionNode.getString("indexfolder");
        String indexSection = collectionNode.getString("indexsection", null);
        IRCollection collection = new IRCollection();
        if (indexSection == null || indexSection.trim().length() == 0) {
            collection.load(indexFolder + "/collection.stat");
        } else {
            collection.load(indexFolder + "/" + indexSection + "/collection.stat");
        }
        return collection;
    }

    public IndexReader getIndexReader(int indexReaderID) {
        return this.getIndexReader(this.root, indexReaderID);
    }

    public IndexReader getIndexReader(ConfigureNode node, int indexReaderID) {
        return this.loadIndexReader(node, indexReaderID);
    }

    private IndexReader loadIndexReader(ConfigureNode node, int indexReaderID) {
        ConfigureNode indexReaderNode = this.getConfigureNode(node, "indexreader", indexReaderID);
        if (indexReaderNode == null) {
            return null;
        }
        String indexReaderName = indexReaderNode.getNodeName();
        return this.loadIndexReader(indexReaderName, indexReaderNode);
    }

    protected IndexReader loadIndexReader(String indexReaderName, ConfigureNode indexReaderNode) {
        if (indexReaderName.equalsIgnoreCase("BasicIndexReader")) {
            return this.loadBasicIndexReader(indexReaderNode);
        }
        if (indexReaderName.equalsIgnoreCase("OnlineIndexReader")) {
            return this.loadOnlineIndexReader(indexReaderNode);
        }
        if (indexReaderName.equalsIgnoreCase("BasicSentenceIndexReader")) {
            return this.loadBasicSentenceIndexReader(indexReaderNode);
        }
        if (indexReaderName.equalsIgnoreCase("OnlineSentenceIndexReader")) {
            return this.loadOnlineSentenceIndexReader(indexReaderNode);
        }
        if (indexReaderName.equalsIgnoreCase("BasicSequenceIndexReader")) {
            return this.loadBasicSequenceIndexReader(indexReaderNode);
        }
        if (indexReaderName.equalsIgnoreCase("OnlineSequenceIndexReader")) {
            return this.loadOnlineSequenceIndexReader(indexReaderNode);
        }
        return (IndexReader)this.loadResource(indexReaderNode);
    }

    private IndexReader loadBasicSentenceIndexReader(ConfigureNode curNode) {
        String folder = curNode.getString("indexfolder");
        BasicSentenceIndexReader reader = new BasicSentenceIndexReader(folder, true);
        reader.initialize();
        return reader;
    }

    private IndexReader loadOnlineSentenceIndexReader(ConfigureNode curNode) {
        int indexerID = curNode.getInt("onlineindexer");
        int collectionReaderID = curNode.getInt("collectionreader");
        OnlineSentenceIndexer indexer = (OnlineSentenceIndexer)new IndexerConfig().getIndexer(curNode, indexerID);
        CollectionReader collectionReader = new CollectionReaderConfig().getCollectionReader(curNode, collectionReaderID);
        OnlineSentenceIndexReader reader = new OnlineSentenceIndexReader(indexer, collectionReader);
        reader.initialize();
        return reader;
    }

    private IndexReader loadBasicSequenceIndexReader(ConfigureNode curNode) {
        int collectionReaderID = curNode.getInt("collectionreader", -1);
        CollectionReader collectionReader = collectionReaderID == -1 ? null : new CollectionReaderConfig().getCollectionReader(curNode, collectionReaderID);
        String folder = curNode.getString("indexfolder");
        BasicSequenceIndexReader reader = new BasicSequenceIndexReader(folder, collectionReader);
        reader.initialize();
        return reader;
    }

    private IndexReader loadOnlineSequenceIndexReader(ConfigureNode curNode) {
        int collectionReaderID = curNode.getInt("collectionreader");
        if (collectionReaderID <= 0) {
            return null;
        }
        CollectionReader collectionReader = new CollectionReaderConfig().getCollectionReader(curNode, collectionReaderID);
        int extractorID = curNode.getInt("conceptextractor");
        if (extractorID > 0) {
            ConceptExtractor ce = new ConceptExtractorConfig().getConceptExtractor(curNode, extractorID);
            OnlineSequenceIndexReader reader = new OnlineSequenceIndexReader(ce, collectionReader);
            reader.initialize();
            return reader;
        }
        int indexerID = curNode.getInt("onlineindexer");
        OnlineSequenceIndexer indexer = (OnlineSequenceIndexer)new IndexerConfig().getIndexer(curNode, indexerID);
        if (indexer == null) {
            return null;
        }
        OnlineSequenceIndexReader reader = new OnlineSequenceIndexReader(indexer, collectionReader);
        reader.initialize();
        return reader;
    }

    private IndexReader loadOnlineIndexReader(ConfigureNode curNode) {
        int indexerID = curNode.getInt("onlineindexer");
        int collectionReaderID = curNode.getInt("collectionreader");
        OnlineIndexer indexer = (OnlineIndexer)new IndexerConfig().getIndexer(curNode, indexerID);
        CollectionReader collectionReader = new CollectionReaderConfig().getCollectionReader(curNode, collectionReaderID);
        OnlineIndexReader reader = new OnlineIndexReader(indexer, collectionReader);
        reader.initialize();
        return reader;
    }

    private IndexReader loadBasicIndexReader(ConfigureNode curNode) {
        BasicIndexReader reader;
        int collectionReaderID = curNode.getInt("collectionreader", -1);
        CollectionReader collectionReader = collectionReaderID == -1 ? null : new CollectionReaderConfig().getCollectionReader(curNode, collectionReaderID);
        String folder = curNode.getString("indexfolder");
        String indexSection = curNode.getString("indexsection", null);
        if (indexSection == null || indexSection.trim().length() == 0) {
            reader = new BasicIndexReader(folder, true, collectionReader);
            reader.initialize();
        } else {
            reader = new BasicIndexReader(folder + "/" + indexSection, true, collectionReader);
            reader.initialize();
            reader.setIRDocKeyList(new SimpleElementList(folder + "/dockey.list", false));
            reader.setIRTermKeyList(new SimpleElementList(folder + "/termkey.list", false));
        }
        return reader;
    }
}

