/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.index.IndexConverter;

public class IndexConvertAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and indexing applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode indexAppNode = util.getConfigureNode(root2, "indexconvertapp", Integer.parseInt(args[1]));
        if (indexAppNode == null) {
            return;
        }
        IndexConvertAppConfig indexApp = new IndexConvertAppConfig();
        indexApp.convert(indexAppNode);
    }

    public void convert(ConfigureNode node) {
        String task = node.getString("task");
        String indexFolder = node.getString("indexfolder");
        if (task == null || indexFolder == null) {
            return;
        }
        String doctermFile = node.getString("doctermfile");
        String doclinkFile = node.getString("doclinkagefile");
        boolean outputTransposedMatrix = node.getBoolean("gentransposedmatrix", false);
        IndexConverter converter = new IndexConverter();
        if (task.equalsIgnoreCase("import")) {
            if (doctermFile != null && doctermFile.trim().length() > 0) {
                converter.importIndex(indexFolder, doctermFile);
            }
            if (doclinkFile != null && doclinkFile.trim().length() > 0) {
                converter.importDocLinkage(indexFolder, doclinkFile, outputTransposedMatrix);
            }
        } else if (task.equalsIgnoreCase("export")) {
            if (doctermFile != null && doctermFile.trim().length() > 0) {
                converter.exportIndex(indexFolder, doctermFile);
            }
            if (doclinkFile != null && doclinkFile.trim().length() > 0) {
                converter.exportDocLinkage(indexFolder, doclinkFile);
            }
        }
    }
}

