/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.clustering.featurefilter.DocFrequencyFilter;
import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.clustering.featurefilter.NullFeatureFilter;

public class FeatureFilterConfig
extends ConfigUtil {
    public FeatureFilterConfig() {
    }

    public FeatureFilterConfig(ConfigureNode root2) {
        super(root2);
    }

    public FeatureFilterConfig(String configFile) {
        super(configFile);
    }

    public FeatureFilter getFeatureFilter(int filterID) {
        return this.getFeatureFilter(this.root, filterID);
    }

    public FeatureFilter getFeatureFilter(ConfigureNode node, int filterID) {
        return this.loadFeatureFilter(node, filterID);
    }

    private FeatureFilter loadFeatureFilter(ConfigureNode node, int filterID) {
        ConfigureNode filterNode = this.getConfigureNode(node, "featurefilter", filterID);
        if (filterNode == null) {
            return null;
        }
        String filterName = filterNode.getNodeName();
        return this.loadFeatureFilter(filterName, filterNode);
    }

    protected FeatureFilter loadFeatureFilter(String filterName, ConfigureNode filterNode) {
        if (filterName.equalsIgnoreCase("NullFeatureFilter")) {
            return new NullFeatureFilter();
        }
        if (filterName.equalsIgnoreCase("DocFrequencyFilter")) {
            return this.loadDocFrequencySelector(filterNode);
        }
        return (FeatureFilter)this.loadResource(filterNode);
    }

    private FeatureFilter loadDocFrequencySelector(ConfigureNode node) {
        return new DocFrequencyFilter(node.getInt("mindocfrequency", 5));
    }
}

