/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.clustering.docdistance.CosineDocDistance;
import dragon.ir.clustering.docdistance.DocDistance;
import dragon.ir.clustering.docdistance.EuclideanDocDistance;
import dragon.ir.clustering.docdistance.KLDivDocDistance;
import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleSparseMatrix;

public class DocDistanceConfig
extends ConfigUtil {
    public DocDistanceConfig() {
    }

    public DocDistanceConfig(ConfigureNode root2) {
        super(root2);
    }

    public DocDistanceConfig(String configFile) {
        super(configFile);
    }

    public DocDistance getDocDistance(int docDistanceID) {
        return this.getDocDistance(this.root, docDistanceID);
    }

    public DocDistance getDocDistance(ConfigureNode node, int docDistanceID) {
        return this.loadDocDistance(node, docDistanceID);
    }

    private DocDistance loadDocDistance(ConfigureNode node, int docDistanceID) {
        ConfigureNode docDistanceNode = this.getConfigureNode(node, "docdistance", docDistanceID);
        if (docDistanceNode == null) {
            return null;
        }
        String docDistanceName = docDistanceNode.getNodeName();
        return this.loadDocDistance(docDistanceName, docDistanceNode);
    }

    protected DocDistance loadDocDistance(String docDistanceName, ConfigureNode docDistanceNode) {
        if (docDistanceName.equalsIgnoreCase("CosineDocDistance")) {
            return this.loadCosineDocDistance(docDistanceNode);
        }
        if (docDistanceName.equalsIgnoreCase("EuclideanDocDistance")) {
            return this.loadEuclideanDocDistance(docDistanceNode);
        }
        if (docDistanceName.equalsIgnoreCase("KLDivDocDistance")) {
            return this.loadKLDivDocDistance(docDistanceNode);
        }
        return (DocDistance)this.loadResource(docDistanceNode);
    }

    private DocDistance loadCosineDocDistance(ConfigureNode node) {
        int matrixID = node.getInt("doublematrix", -1);
        if (matrixID > 0) {
            return new CosineDocDistance(new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        matrixID = node.getInt("intmatrix", -1);
        return new CosineDocDistance(new SparseMatrixConfig().getIntSparseMatrix(node, matrixID));
    }

    private DocDistance loadEuclideanDocDistance(ConfigureNode node) {
        int matrixID = node.getInt("doublematrix", -1);
        if (matrixID > 0) {
            return new EuclideanDocDistance(new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID));
        }
        matrixID = node.getInt("intmatrix", -1);
        return new EuclideanDocDistance(new SparseMatrixConfig().getIntSparseMatrix(node, matrixID));
    }

    private DocDistance loadKLDivDocDistance(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        int matrixID = node.getInt("doublematrix");
        DoubleSparseMatrix matrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, matrixID);
        double normThreshold = node.getDouble("normthreshold", 0.0);
        if (indexReader != null) {
            return new KLDivDocDistance(indexReader, matrix, normThreshold);
        }
        return new KLDivDocDistance(indexReader, matrix);
    }
}

