/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SparseMatrixConfig;
import dragon.ir.index.BasicIRTermIndexList;
import dragon.ir.kngbase.CooccurrenceGenerator;
import dragon.matrix.IntSparseMatrix;

public class CooccurrenceAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and indexing applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode appNode = util.getConfigureNode(root2, "cooccurrenceapp", Integer.parseInt(args[1]));
        if (appNode == null) {
            return;
        }
        CooccurrenceAppConfig cooccurApp = new CooccurrenceAppConfig();
        cooccurApp.generateCooccurrenceMatrix(appNode);
    }

    public void generateCooccurrenceMatrix(ConfigureNode node) {
        int minDocFreq = node.getInt("mindocfrequency", 1);
        int maxDocFreq = node.getInt("maxdocfrequency", Integer.MAX_VALUE);
        int cache = node.getInt("cache", 5000000);
        String matrixFolder = node.getString("cooccurrencematrixpath");
        String matrixKey = node.getString("cooccurrencematrixkey");
        int matrixAID = node.getInt("firstmatrix");
        int matrixBID = node.getInt("secondmatrix", matrixAID);
        String indexListFileA = node.getString("firstindexlistfile", null);
        String indexListFileB = node.getString("secondindexlistfile", null);
        IntSparseMatrix matrixA = new SparseMatrixConfig().getIntSparseMatrix(node, matrixAID);
        if (matrixAID == matrixBID) {
            this.generateCooccurrenceMatrix(matrixA, indexListFileA, matrixFolder, matrixKey, cache, minDocFreq, maxDocFreq);
        } else {
            IntSparseMatrix matrixB = new SparseMatrixConfig().getIntSparseMatrix(node, matrixBID);
            this.generateCooccurrenceMatrix(matrixA, indexListFileA, matrixB, indexListFileB, matrixFolder, matrixKey, cache, minDocFreq, maxDocFreq);
        }
    }

    public void generateCooccurrenceMatrix(IntSparseMatrix doctermMatrixA, String indexListFileA, IntSparseMatrix doctermMatrixB, String indexListFileB, String matrixFolder, String matrixKey, int cache, int minDocFreq, int maxDocFreq) {
        CooccurrenceGenerator generator = new CooccurrenceGenerator();
        generator.setCacheSize(cache);
        generator.setMinDocFrequency(minDocFreq);
        generator.setMaxDocFrequency(maxDocFreq);
        generator.generate(doctermMatrixA, this.getTermDocFrequencyList(indexListFileA), doctermMatrixB, this.getTermDocFrequencyList(indexListFileB), matrixFolder, matrixKey);
    }

    public void generateCooccurrenceMatrix(IntSparseMatrix doctermMatrix, String indexListFile, String matrixFolder, String matrixKey, int cache, int minDocFreq, int maxDocFreq) {
        CooccurrenceGenerator generator = new CooccurrenceGenerator();
        generator.setCacheSize(cache);
        generator.setMinDocFrequency(minDocFreq);
        generator.setMaxDocFrequency(maxDocFreq);
        generator.generate(doctermMatrix, this.getTermDocFrequencyList(indexListFile), matrixFolder, matrixKey);
    }

    public int[] getTermDocFrequencyList(String indexListFile) {
        if (indexListFile == null) {
            return null;
        }
        BasicIRTermIndexList list2 = new BasicIRTermIndexList(indexListFile, false);
        int[] arrDocFreq = new int[list2.size()];
        int i = 0;
        while (i < list2.size()) {
            arrDocFreq[i] = list2.get(i).getDocFrequency();
            ++i;
        }
        return arrDocFreq;
    }
}

