/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ClassifierConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.classification.ClassificationEva;
import dragon.ir.classification.Classifier;
import dragon.ir.classification.DocClass;
import dragon.ir.classification.DocClassSet;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.vector.DoubleVector;
import dragon.nlp.SimpleElementList;
import dragon.nlp.compare.IndexComparator;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import dragon.util.MathUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.TreeMap;

public class ClassificationEvaAppConfig {
    private DecimalFormat df = FormatUtil.getNumericFormat(1, 4);
    private PrintWriter out;
    private TreeMap map = new TreeMap();
    private ArrayList labelList = new ArrayList();
    private int maxCategory = 0;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and clustering evaluation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root2 = new BasicConfigureNode(args[0]);
        ConfigureNode classificationAppNode = util.getConfigureNode(root2, "classificationevaapp", Integer.parseInt(args[1]));
        if (classificationAppNode == null) {
            return;
        }
        ClassificationEvaAppConfig classificationApp = new ClassificationEvaAppConfig();
        classificationApp.evaluate(classificationAppNode);
    }

    public void evaluate(ConfigureNode node) {
        String dockeyFile = node.getString("dockeyfile", null);
        SimpleElementList dockeyList = dockeyFile == null ? null : new SimpleElementList(dockeyFile, false);
        int classNum = node.getInt("classnum");
        int classifierID = node.getInt("classifier");
        Classifier classifier = new ClassifierConfig().getClassifier(node, classifierID);
        String validatingKeyFile = node.getString("validatingkeyfile", null);
        String outputFile = node.getString("outputfile");
        String runName = node.getString("runname");
        String mode = node.getString("mode");
        if (mode == null) {
            return;
        }
        if (mode.equalsIgnoreCase("CrossValidation")) {
            String answerKeyFile = node.getString("answerkeyfile");
            int foldNum = node.getInt("foldnum", 5);
            this.evaluateCrossValidation(classifier, dockeyList, classNum, answerKeyFile, validatingKeyFile, foldNum, runName, outputFile);
        } else if (mode.equalsIgnoreCase("Percentage")) {
            int randomSeed = node.getInt("randomseed", -1);
            int runs = node.getInt("runs", 1);
            String answerKeyFile = node.getString("answerkeyfile");
            double percentage = node.getDouble("percentage", 0.67);
            if (percentage > 1.0) {
                percentage /= 100.0;
            }
            this.evaluatePercentage(classifier, dockeyList, classNum, answerKeyFile, validatingKeyFile, percentage, runs, randomSeed, runName, outputFile);
        } else if (mode.equalsIgnoreCase("Manual")) {
            String trainingKeyFile = node.getString("trainingkeyfile");
            String testingKeyFile = node.getString("testingkeyfile");
            this.evaluateManual(classifier, dockeyList, classNum, trainingKeyFile, validatingKeyFile, testingKeyFile, runName, outputFile);
        } else {
            return;
        }
        this.out.close();
    }

    public void evaluateCrossValidation(Classifier classifier, int classNum, String answerKeyFile, String validatingKeyFile, int foldNum, String runName, String outputFile) {
        this.evaluateCrossValidation(classifier, null, classNum, answerKeyFile, validatingKeyFile, foldNum, runName, outputFile);
    }

    public void evaluateCrossValidation(Classifier classifier, SimpleElementList dockeyList, int classNum, String answerKeyFile, String validatingKeyFile, int foldNum, String runName, String outputFile) {
        this.map.clear();
        this.maxCategory = 0;
        this.labelList.clear();
        this.out = FileUtil.getPrintWriter(outputFile, true);
        IndexReader indexReader = classifier.getIndexReader();
        DocClassSet validatingSet = validatingKeyFile != null ? this.getDocClassSet(this.getAnswerKeyList(indexReader, dockeyList, validatingKeyFile), classNum) : null;
        ArrayList answerKeyList = this.getAnswerKeyList(indexReader, dockeyList, answerKeyFile);
        Collections.shuffle(answerKeyList, new Random(100L));
        ArrayList[] folds = this.split(answerKeyList, foldNum);
        int top = Math.min(5, classNum - 1);
        DoubleVector result2 = new DoubleVector(7 + top);
        result2.assign(0.0);
        this.write("Number of Classes: " + classNum + "\n");
        this.write("Number of Documents: " + answerKeyList.size() + "\n");
        this.write("Number of Folds: " + foldNum + "\n");
        this.printHeader(top);
        int i = 0;
        while (i < foldNum) {
            DocClassSet trainingSet = this.getCrossTrainingSet(folds, i, classNum);
            int[] answers = this.getAnswers(folds[i]);
            DocClass testingDocs = this.getDocClass(folds[i]);
            classifier.train(trainingSet, validatingSet);
            result2.add(this.evaluate(classifier, classNum, testingDocs, answers, runName + "_" + (i + 1)));
            ++i;
        }
        result2.multiply(1.0 / (double)foldNum);
        this.writeResult("Average", result2);
    }

    public void evaluatePercentage(Classifier classifier, int classNum, String answerKeyFile, String validatingKeyFile, double percentage, int runs, int randomSeed, String runName, String outputFile) {
        this.evaluatePercentage(classifier, null, classNum, answerKeyFile, validatingKeyFile, percentage, runs, randomSeed, runName, outputFile);
    }

    public void evaluatePercentage(Classifier classifier, SimpleElementList dockeyList, int classNum, String answerKeyFile, String validatingKeyFile, double percentage, int runs, int randomSeed, String runName, String outputFile) {
        this.map.clear();
        this.maxCategory = 0;
        this.labelList.clear();
        this.out = FileUtil.getPrintWriter(outputFile, true);
        Random random = randomSeed >= 0 ? new Random(randomSeed) : new Random();
        IndexReader indexReader = classifier.getIndexReader();
        DocClassSet validatingSet = validatingKeyFile != null ? this.getDocClassSet(this.getAnswerKeyList(indexReader, dockeyList, validatingKeyFile), classNum) : null;
        ArrayList answerKeyList = this.getAnswerKeyList(indexReader, dockeyList, answerKeyFile);
        int top = Math.min(5, classNum - 1);
        DoubleVector result2 = new DoubleVector(7 + top);
        result2.assign(0.0);
        this.write("Number of Classes: " + classNum + "\n");
        this.write("Number of Documents: " + answerKeyList.size() + "\n");
        this.write("Percentage of Training: " + this.df.format(percentage) + "\n");
        this.write("Number of Runs: " + runs + "\n");
        this.write("Random Seed: " + randomSeed + "\n");
        this.printHeader(top);
        int i = 0;
        while (i < runs) {
            ArrayList list2 = new ArrayList(answerKeyList);
            Collections.shuffle(list2, random);
            ArrayList[] arrList = this.split(list2, classNum, percentage);
            DocClassSet trainingSet = this.getDocClassSet(arrList[0], classNum);
            int[] answers = this.getAnswers(arrList[1]);
            DocClass testingDocs = this.getDocClass(arrList[1]);
            classifier.train(trainingSet, validatingSet);
            result2.add(this.evaluate(classifier, classNum, testingDocs, answers, runName + "_" + (i + 1)));
            ++i;
        }
        result2.multiply(1.0 / (double)runs);
        this.writeResult("Average", result2);
    }

    public void evaluateManual(Classifier classifier, int classNum, String trainingKeyFile, String validatingKeyFile, String testingKeyFile, String runName, String outputFile) {
        this.evaluateManual(classifier, null, classNum, trainingKeyFile, validatingKeyFile, testingKeyFile, runName, outputFile);
    }

    public void evaluateManual(Classifier classifier, SimpleElementList dockeyList, int classNum, String trainingKeyFile, String validatingKeyFile, String testingKeyFile, String runName, String outputFile) {
        this.map.clear();
        this.maxCategory = 0;
        this.labelList.clear();
        this.out = FileUtil.getPrintWriter(outputFile, true);
        IndexReader indexReader = classifier.getIndexReader();
        DocClassSet validatingSet = validatingKeyFile != null ? this.getDocClassSet(this.getAnswerKeyList(indexReader, dockeyList, validatingKeyFile), classNum) : null;
        ArrayList trainingList = this.getAnswerKeyList(indexReader, dockeyList, trainingKeyFile);
        DocClassSet trainingSet = this.getDocClassSet(trainingList, classNum);
        ArrayList testingList = this.getAnswerKeyList(indexReader, dockeyList, testingKeyFile);
        int[] answers = this.getAnswers(testingList);
        DocClass testingDocs = this.getDocClass(testingList);
        this.write("Number of Classes: " + classNum + "\n");
        this.write("Number of Training Documents: " + trainingList.size() + "\n");
        this.write("Number of Testing Documents: " + testingList.size() + "\n");
        classifier.train(trainingSet, validatingSet);
        this.printHeader(Math.min(5, classNum - 1));
        this.evaluate(classifier, classNum, testingDocs, answers, runName);
    }

    private DoubleVector evaluate(Classifier classifier, int classNum, DocClass testingSet, int[] answer, String runName) {
        int[][] arrPrediction = new int[testingSet.getDocNum()][];
        int i = 0;
        while (i < testingSet.getDocNum()) {
            int label = classifier.classify(testingSet.getDoc(i));
            if (label >= 0) {
                arrPrediction[i] = classifier.rank();
            }
            ++i;
        }
        int dim = Math.min(5, classNum - 1);
        DoubleVector result2 = new DoubleVector(7 + dim);
        ClassificationEva eva = new ClassificationEva();
        eva.evaluate(classNum, answer, arrPrediction);
        result2.set(0, eva.getMicroRecall());
        result2.set(1, eva.getMicroPrecision());
        result2.set(2, eva.getMicroFScore());
        result2.set(3, eva.getMacroRecall());
        result2.set(4, eva.getMacroPrecision());
        result2.set(5, eva.getMacroFScore());
        result2.set(6, eva.getMRR());
        i = 0;
        while (i < dim) {
            result2.set(7 + i, eva.getPrecisionN(i));
            ++i;
        }
        this.writeResult(runName, result2);
        return result2;
    }

    private void printHeader(int top) {
        this.write("Run\tmicro-R\tmicro-P\tmicro-F\tmacro-R\tmacro-P\tmacro-F\tMRR");
        int i = 1;
        while (i <= top) {
            this.write("\tP" + i);
            ++i;
        }
        this.write("\n");
    }

    private void writeResult(String runName, DoubleVector result2) {
        this.write(runName);
        int i = 0;
        while (i < result2.size()) {
            this.write("\t");
            this.write(this.df.format(result2.get(i)));
            ++i;
        }
        this.write("\n");
    }

    private void write(String message) {
        System.out.print(message);
        this.out.write(message);
        this.out.flush();
    }

    private DocClassSet getCrossTrainingSet(ArrayList[] folds, int leaveoutFold, int classNum) {
        ArrayList list2 = new ArrayList();
        int i = 0;
        while (i < folds.length) {
            if (i != leaveoutFold) {
                list2.addAll(folds[i]);
            }
            ++i;
        }
        return this.getDocClassSet(list2, classNum);
    }

    private ArrayList[] split(ArrayList docList, int foldNum) {
        ArrayList[] folds = new ArrayList[foldNum];
        int i = 0;
        while (i < foldNum) {
            folds[i] = new ArrayList(docList.size() / foldNum + 1);
            ++i;
        }
        i = 0;
        while (i < docList.size()) {
            folds[i % foldNum].add(docList.get(i));
            ++i;
        }
        return folds;
    }

    private ArrayList[] split(ArrayList docList, int classNum, double trainingPercentage) {
        int[] arrStat = new int[classNum];
        MathUtil.initArray(arrStat, 0);
        int i = 0;
        while (i < docList.size()) {
            int n = ((IRDoc)docList.get(i)).getCategory();
            arrStat[n] = arrStat[n] + 1;
            ++i;
        }
        i = 0;
        while (i < classNum) {
            arrStat[i] = (int)((double)arrStat[i] * trainingPercentage + 0.5);
            if (arrStat[i] == 0) {
                arrStat[i] = 1;
            }
            ++i;
        }
        ArrayList[] arrList = new ArrayList[]{new ArrayList(), new ArrayList()};
        int[] arrCount = new int[classNum];
        MathUtil.initArray(arrCount, 0);
        i = 0;
        while (i < docList.size()) {
            IRDoc curDoc = (IRDoc)docList.get(i);
            if (arrCount[curDoc.getCategory()] >= arrStat[curDoc.getCategory()]) {
                arrList[1].add(curDoc);
            } else {
                arrList[0].add(curDoc);
                int n = curDoc.getCategory();
                arrCount[n] = arrCount[n] + 1;
            }
            ++i;
        }
        return arrList;
    }

    private DocClass getDocClass(ArrayList docList) {
        DocClass set = new DocClass(-1);
        int i = 0;
        while (i < docList.size()) {
            IRDoc curDoc = (IRDoc)docList.get(i);
            set.addDoc(curDoc.copy());
            ++i;
        }
        return set;
    }

    private DocClassSet getDocClassSet(ArrayList docList, int classNum) {
        DocClassSet set = new DocClassSet(classNum);
        int i = 0;
        while (i < docList.size()) {
            IRDoc curDoc = (IRDoc)docList.get(i);
            set.addDoc(curDoc.getCategory(), curDoc.copy());
            ++i;
        }
        i = 0;
        while (i < set.getClassNum()) {
            set.getDocClass(i).setClassName((String)this.labelList.get(i));
            ++i;
        }
        return set;
    }

    private int[] getAnswers(ArrayList docList) {
        SortedArray list2 = new SortedArray();
        list2.addAll(docList);
        list2.setComparator(new IndexComparator());
        int[] answers = new int[list2.size()];
        int i = 0;
        while (i < list2.size()) {
            answers[i] = ((IRDoc)list2.get(i)).getCategory();
            ++i;
        }
        return answers;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList getAnswerKeyList(IndexReader indexReader, SimpleElementList dockeyList, String answerKeyFile) {
        try {
            String line;
            BufferedReader br = FileUtil.getTextReader(answerKeyFile);
            SortedArray answerKeyList = new SortedArray(Integer.parseInt(br.readLine()), new IndexComparator());
            while ((line = br.readLine()) != null) {
                Integer curCategory;
                IRDoc irDoc;
                void var8_8;
                String[] arrTopic = var8_8.split("\t");
                if (indexReader != null) {
                    irDoc = indexReader.getDoc(arrTopic[1]);
                    if (irDoc == null || irDoc.getTermNum() < 1) {
                        continue;
                    }
                } else {
                    irDoc = new IRDoc(arrTopic[1]);
                    irDoc.setIndex(dockeyList.search(arrTopic[1]));
                }
                if ((curCategory = (Integer)this.map.get(arrTopic[0])) == null) {
                    curCategory = new Integer(this.maxCategory);
                    ++this.maxCategory;
                    this.map.put(arrTopic[0], curCategory);
                    this.labelList.add(arrTopic[0]);
                }
                irDoc.setCategory(curCategory);
                answerKeyList.add(irDoc);
            }
            br.close();
            return answerKeyList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

