/*
 * Decompiled with CFR 0.152.
 */
package dl.tmp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.ac.cam.ch.wwmm.opsin.InchiPruner;
import uk.ac.cam.ch.wwmm.opsin.NameToInchi;
import uk.ac.cam.ch.wwmm.opsin.NameToStructure;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;

public class RegressionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String testFilesDirectoryName = "C:/My Documents/OPSIN/TrainingSets/";
        String resultsDirectoryName = "C:/My Documents/OPSIN/RegressionTesting/";
        File testFilesDirectory = new File(testFilesDirectoryName);
        if (!testFilesDirectory.isDirectory()) {
            throw new RuntimeException("testFilesDirectoryName should describe a valid directory");
        }
        File resultsDirectory = new File(resultsDirectoryName);
        if (!resultsDirectory.isDirectory()) {
            throw new RuntimeException("resultsDirectoryName should describe a valid directory");
        }
        File[] resultsFolders = resultsDirectory.listFiles();
        File referenceFolder = null;
        for (File resultsFolder : resultsFolders) {
            if (referenceFolder != null && resultsFolder.lastModified() <= referenceFolder.lastModified()) continue;
            referenceFolder = resultsFolder;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy_MMMM_dd_HH-mm");
        String currentDate = dateFormat.format(new Date());
        File specificResultsDirectory = new File(resultsDirectoryName, currentDate);
        specificResultsDirectory.mkdir();
        File summaryFile = new File(specificResultsDirectory, "summary.txt");
        BufferedWriter summaryOutput = new BufferedWriter(new FileWriter(summaryFile));
        File diffFile = new File(specificResultsDirectory, "differences.txt");
        BufferedWriter diffOutput = new BufferedWriter(new FileWriter(diffFile));
        File[] testFiles = testFilesDirectory.listFiles();
        NameToStructure n2s = NameToStructure.getInstance();
        NameToStructureConfig n2sconfig = NameToStructureConfig.getDefaultConfigInstance();
        n2sconfig.setAllowRadicals(true);
        for (File testFile : testFiles) {
            if (!testFile.isFile()) continue;
            BufferedReader testFileInput = new BufferedReader(new FileReader(testFile));
            File outputFile = new File(specificResultsDirectory, testFile.getName());
            BufferedWriter output2 = new BufferedWriter(new FileWriter(outputFile));
            File referenceFile = new File(referenceFolder, testFile.getName());
            BufferedReader referenceInput = null;
            if (referenceFile.exists()) {
                referenceInput = new BufferedReader(new FileReader(referenceFile));
            }
            long start = System.currentTimeMillis();
            int correctInchis = 0;
            int incorrectInchis = 0;
            int totalNames = 0;
            int interpretable = 0;
            boolean inchiPresent = false;
            try {
                String nameFileLine = null;
                while ((nameFileLine = testFileInput.readLine()) != null) {
                    String referenceInchi = null;
                    if (referenceInput != null) {
                        referenceInchi = InchiPruner.mainChargeAndStereochemistryLayers(referenceInput.readLine());
                    }
                    ++totalNames;
                    String[] lineArray = nameFileLine.split("\t");
                    String inchi = NameToInchi.convertResultToInChI(n2s.parseChemicalName(lineArray[0], n2sconfig));
                    Boolean currentInterpretationCorrect = null;
                    String opsinInchi = "";
                    String correctInchi = null;
                    if (lineArray.length > 1) {
                        inchiPresent = true;
                        correctInchi = InchiPruner.mainChargeAndStereochemistryLayers(lineArray[1]);
                    }
                    if (inchi != null) {
                        output2.write(inchi + "\n");
                        opsinInchi = InchiPruner.mainChargeAndStereochemistryLayers(inchi);
                        ++interpretable;
                        if (correctInchi != null) {
                            if (opsinInchi.equals(correctInchi)) {
                                ++correctInchis;
                                currentInterpretationCorrect = true;
                            } else {
                                ++incorrectInchis;
                                currentInterpretationCorrect = false;
                            }
                        }
                    } else {
                        output2.write("\n");
                    }
                    if (referenceInchi == null || opsinInchi.equals(referenceInchi)) continue;
                    diffOutput.write("**********************************\n");
                    diffOutput.write(testFile.getName() + ": Name: " + lineArray[0] + "\n");
                    System.out.print(testFile.getName() + ": Name: " + lineArray[0] + " is now ");
                    if (correctInchi != null) {
                        if (referenceInchi.equals(correctInchi)) {
                            diffOutput.write("previous: CORRECT " + referenceInchi + "\n");
                            if (currentInterpretationCorrect != null) {
                                if (currentInterpretationCorrect.booleanValue()) {
                                    throw new RuntimeException("previous and current can't be different and both correct");
                                }
                                diffOutput.write("current: INCORRECT " + opsinInchi + "\n");
                                System.out.println("INCORRECT (was correct)");
                                continue;
                            }
                            diffOutput.write("current: UNINTERPRETABLE " + opsinInchi + "\n");
                            System.out.println("UNINTERPRETABLE (was correct)");
                            continue;
                        }
                        if (referenceInchi.equals("")) {
                            diffOutput.write("previous: UNINTERPRETABLE\n");
                            if (currentInterpretationCorrect == null) continue;
                            if (currentInterpretationCorrect.booleanValue()) {
                                diffOutput.write("current: CORRECT " + opsinInchi + "\n");
                                System.out.println("CORRECT (was uninterpretable)");
                                continue;
                            }
                            diffOutput.write("current: INCORRECT " + opsinInchi + "\n");
                            if (InchiPruner.mainAndChargeLayers(inchi).equals(InchiPruner.mainAndChargeLayers(correctInchi))) {
                                System.out.println("INCORRECT just in stereochemical layer (but was previously uninterpretable)");
                                continue;
                            }
                            System.out.println("INCORRECT (but was previously uninterpretable)");
                            continue;
                        }
                        diffOutput.write("previous: INCORRECT " + referenceInchi + "\n");
                        if (currentInterpretationCorrect != null) {
                            if (currentInterpretationCorrect.booleanValue()) {
                                diffOutput.write("current: CORRECT " + opsinInchi + "\n");
                                System.out.println("CORRECT (was incorrect)");
                                continue;
                            }
                            diffOutput.write("current: INCORRECT " + opsinInchi + "\n");
                            System.out.println("INCORRECT (but was previously  incorrect)");
                            continue;
                        }
                        diffOutput.write("current: UNINTERPRETABLE " + opsinInchi + "\n");
                        System.out.println("UNINTERPRETABLE (was incorrect)");
                        continue;
                    }
                    if (referenceInchi.equals("")) {
                        System.out.println("DIFFERENT (previously UNINTERPRETABLE)");
                        diffOutput.write("previous: " + referenceInchi + "\n");
                        diffOutput.write("current: " + opsinInchi + "\n");
                        continue;
                    }
                    if (opsinInchi.equals("")) {
                        System.out.println("DIFFERENT (now UNINTERPRETABLE)");
                        diffOutput.write("previous: " + referenceInchi + "\n");
                        diffOutput.write("current: " + opsinInchi + "\n");
                        continue;
                    }
                    System.out.println("DIFFERENT");
                    diffOutput.write("previous: " + referenceInchi + "\n");
                    diffOutput.write("current: " + opsinInchi + "\n");
                }
            }
            finally {
                testFileInput.close();
                output2.close();
            }
            summaryOutput.write("**********************************\n");
            summaryOutput.write(testFile.getName() + "\n");
            if (inchiPresent) {
                summaryOutput.write(totalNames + " names were inputted, resulting in " + correctInchis + " correct INCHIs and " + incorrectInchis + " incorrect Inchis (" + (totalNames - interpretable) + " uninterpretable)" + "\n");
            } else {
                summaryOutput.write(totalNames + " names were inputted, resulting in " + interpretable + " names (" + (totalNames - interpretable) + " uninterpretable)" + "\n");
            }
            long elapsedTimeMillis = System.currentTimeMillis() - start;
            summaryOutput.write("Time taken: " + elapsedTimeMillis + " ms\n");
        }
        diffOutput.close();
        summaryOutput.close();
    }
}

