/*
 * Decompiled with CFR 0.152.
 */
package dl.tmp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class AllIupacNamesInPubChemExtractor {
    public static void main(String[] args) throws Exception {
        File pubChemDirectory = new File("C:/My Documents/workspace/Oscar3-SVN/npc/PubChemFiles");
        if (!pubChemDirectory.isDirectory()) {
            throw new RuntimeException("Directory expected");
        }
        BufferedWriter output2 = new BufferedWriter(new FileWriter("C:/My Documents/OPSIN/resources/allPubChemIupacNames5thJuly10STDInChIs.txt"));
        File[] files = pubChemDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File currentFile = files[i];
            String fileName = currentFile.getName();
            if (!fileName.endsWith(".sdf.gz")) continue;
            System.out.println(fileName);
            BufferedReader compoundsFile = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(currentFile))));
            String cLine = compoundsFile.readLine();
            String inchi = null;
            String iupacName = null;
            while (cLine != null) {
                if ("> <PUBCHEM_IUPAC_NAME>".equals(cLine)) {
                    iupacName = cLine = compoundsFile.readLine();
                } else if ("> <PUBCHEM_NIST_INCHI>".equals(cLine)) {
                    inchi = cLine = compoundsFile.readLine();
                } else if ("$$$$".equals(cLine)) {
                    if (inchi != null && iupacName != null) {
                        output2.write(iupacName + "\t");
                        output2.write(inchi);
                        output2.write("\n");
                    }
                    inchi = null;
                    iupacName = null;
                }
                cLine = compoundsFile.readLine();
            }
        }
        output2.close();
    }
}

