/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.State;
import java.io.Serializable;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    char min;
    char max;
    State to;

    public Transition(char c, State state) {
        this.min = this.max = c;
        this.to = state;
    }

    public Transition(char c, char c2, State state) {
        if (c2 < c) {
            char c3 = c2;
            c2 = c;
            c = c3;
        }
        this.min = c;
        this.max = c2;
        this.to = state;
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public State getDest() {
        return this.to;
    }

    public boolean equals(Object object) {
        if (object instanceof Transition) {
            Transition transition = (Transition)object;
            return transition.min == this.min && transition.max == this.max && transition.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        return this.min * 2 + this.max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    static void appendCharString(char c, StringBuilder stringBuilder) {
        if (c >= '!' && c <= '~' && c != '\\' && c != '\"') {
            stringBuilder.append(c);
        } else {
            stringBuilder.append("\\u");
            String string2 = Integer.toHexString(c);
            if (c < '\u0010') {
                stringBuilder.append("000").append(string2);
            } else if (c < '\u0100') {
                stringBuilder.append("00").append(string2);
            } else if (c < '\u1000') {
                stringBuilder.append("0").append(string2);
            } else {
                stringBuilder.append(string2);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Transition.appendCharString(this.min, stringBuilder);
        if (this.min != this.max) {
            stringBuilder.append("-");
            Transition.appendCharString(this.max, stringBuilder);
        }
        stringBuilder.append(" -> ").append(this.to.number);
        return stringBuilder.toString();
    }

    void appendDot(StringBuilder stringBuilder) {
        stringBuilder.append(" -> ").append(this.to.number).append(" [label=\"");
        Transition.appendCharString(this.min, stringBuilder);
        if (this.min != this.max) {
            stringBuilder.append("-");
            Transition.appendCharString(this.max, stringBuilder);
        }
        stringBuilder.append("\"]\n");
    }
}

