/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.cr.ddi;

import de.berlin.hu.uima.cr.ddi.parser.DDICorpusContentHandlerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DDICorpusCR
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_SUBDIR = "BrowseSubdirectories";
    private ArrayList<File> mFiles;
    private String mEncoding;
    private String mLanguage;
    private Boolean mRecursive;
    private int mCurrentIndex;

    @Override
    public void initialize() throws ResourceInitializationException {
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        this.mEncoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mRecursive = (Boolean)this.getConfigParameterValue(PARAM_SUBDIR);
        if (this.mRecursive == null) {
            this.mRecursive = Boolean.FALSE;
        }
        this.mCurrentIndex = 0;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList();
        this.addFilesFromDir(directory);
    }

    private void addFilesFromDir(File dir2) {
        File[] files = dir2.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].getName().endsWith(".svn")) {
                if (!files[i].isDirectory()) {
                    this.mFiles.add(files[i]);
                } else if (this.mRecursive.booleanValue()) {
                    this.addFilesFromDir(files[i]);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    private void parseCurrentCorpus(File file, JCas jcas) throws SAXException, IOException {
        DDICorpusContentHandlerImpl ppiCorpusContentHandler = new DDICorpusContentHandlerImpl(jcas);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(ppiCorpusContentHandler);
        InputStreamReader fileReader = new InputStreamReader(new FileInputStream(file));
        InputSource inputSource = new InputSource(fileReader);
        xmlReader.parse(inputSource);
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        File currentFile = this.mFiles.get(this.mCurrentIndex++);
        try {
            this.parseCurrentCorpus(currentFile, jcas);
        }
        catch (SAXException e) {
            throw new CollectionException(e);
        }
        if (this.mLanguage != null) {
            ((DocumentAnnotation)jcas.getDocumentAnnotationFs()).setLanguage(this.mLanguage);
        }
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
        srcDocInfo.setUri(currentFile.getAbsoluteFile().toURI().toString());
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)currentFile.length());
        srcDocInfo.setLastSegment(this.mCurrentIndex == this.mFiles.size());
        srcDocInfo.addToIndexes();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mFiles.size();
    }
}

