/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.cc.eval;

import de.berlin.hu.uima.cc.eval.ComparableAnnotation;
import de.berlin.hu.wbi.common.research.Evaluator;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.u_compare.shared.semantic.NamedEntity;

public class SeparateEvaluation
extends CasConsumer_ImplBase {
    private int bothTP = 0;
    private int dictTP = 0;
    private int dictFP = 0;
    private int crfTP = 0;
    private int crfFP = 0;
    private int FN = 0;
    private int GA = 0;
    private int PA = 0;
    private int dictA = 0;
    private int crfA = 0;
    private int dictFN = 0;
    private int crfFN = 0;

    @Override
    public void initialize() throws ResourceInitializationException {
        super.initialize();
    }

    @Override
    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas aJCas;
        ArrayList<NamedEntity> goldAnnotations = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> dictAnnotations = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> crfAnnotations = new ArrayList<NamedEntity>();
        try {
            aJCas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException(e);
        }
        AnnotationIndex<Annotation> namedEntityIndex = aJCas.getAnnotationIndex(NamedEntity.type);
        for (NamedEntity namedEntity : namedEntityIndex) {
            if ("goldstandard".equals(namedEntity.getSource())) {
                goldAnnotations.add(namedEntity);
                ++this.GA;
                continue;
            }
            if ("dictionary".equals(namedEntity.getSource())) {
                dictAnnotations.add(namedEntity);
                ++this.PA;
                ++this.dictA;
                continue;
            }
            if ("crf".equals(namedEntity.getSource())) {
                ++this.PA;
                ++this.crfA;
                crfAnnotations.add(namedEntity);
                continue;
            }
            System.err.println("Annotation without an origin: " + namedEntity.getCoveredText());
            throw new ResourceProcessException();
        }
        this.evaluate(goldAnnotations, dictAnnotations, crfAnnotations, 0);
    }

    public void evaluate(List<NamedEntity> goldAnnotations, List<NamedEntity> dictAnnotations, List<NamedEntity> crfAnnotations, int offset) {
        Evaluator dictEvaluator;
        ArrayList<ComparableAnnotation> goldAnnoationsComparable = new ArrayList<ComparableAnnotation>();
        ArrayList<ComparableAnnotation> dictAnnotationsComparable = new ArrayList<ComparableAnnotation>();
        ArrayList<ComparableAnnotation> crfAnnotationsComparable = new ArrayList<ComparableAnnotation>();
        for (NamedEntity namedEntity : goldAnnotations) {
            goldAnnoationsComparable.add(ComparableAnnotation.createInstance(namedEntity.getBegin(), namedEntity.getEnd(), namedEntity.getCoveredText(), offset));
        }
        for (NamedEntity namedEntity : dictAnnotations) {
            dictAnnotationsComparable.add(ComparableAnnotation.createInstance(namedEntity.getBegin(), namedEntity.getEnd(), namedEntity.getCoveredText(), offset));
        }
        for (NamedEntity namedEntity : crfAnnotations) {
            crfAnnotationsComparable.add(ComparableAnnotation.createInstance(namedEntity.getBegin(), namedEntity.getEnd(), namedEntity.getCoveredText(), offset));
        }
        if (dictAnnotationsComparable.size() > 0 && crfAnnotationsComparable.size() > 0) {
            dictEvaluator = new Evaluator(dictAnnotationsComparable, goldAnnoationsComparable);
            dictEvaluator.evaluate();
            this.dictTP += dictEvaluator.getTruePositives().size();
            this.dictFN += dictEvaluator.getFalseNegatives().size();
            Evaluator crfEvaluator = new Evaluator(crfAnnotationsComparable, goldAnnoationsComparable);
            crfEvaluator.evaluate();
            this.crfTP += crfEvaluator.getTruePositives().size();
            this.crfFN += crfEvaluator.getFalseNegatives().size();
            if (this.crfTP > 0 && this.dictTP > 0) {
                Evaluator evaluator = new Evaluator(crfEvaluator.getTruePositives(), dictEvaluator.getTruePositives());
                evaluator.evaluate();
                this.bothTP += evaluator.getTruePositives().size();
            } else {
                this.bothTP += 0;
            }
        } else if (dictAnnotationsComparable.size() > 0 && crfAnnotationsComparable.size() == 0) {
            System.out.println(String.valueOf(dictAnnotationsComparable.size()) + " " + goldAnnoationsComparable.size());
            dictEvaluator = new Evaluator(dictAnnotationsComparable, goldAnnoationsComparable);
            dictEvaluator.evaluate();
            this.dictTP += dictEvaluator.getTruePositives().size();
            this.dictFN += dictEvaluator.getFalseNegatives().size();
            this.crfTP += 0;
            this.crfFN += goldAnnoationsComparable.size();
            this.bothTP += 0;
        } else if (dictAnnotationsComparable.size() == 0 && crfAnnotationsComparable.size() > 0) {
            Evaluator crfEvaluator = new Evaluator(crfAnnotationsComparable, goldAnnoationsComparable);
            crfEvaluator.evaluate();
            this.crfTP += crfEvaluator.getTruePositives().size();
            this.crfFN += crfEvaluator.getFalseNegatives().size();
            this.dictTP += 0;
            this.dictFN += goldAnnoationsComparable.size();
            this.bothTP += 0;
        } else {
            this.crfTP += 0;
            this.crfFN += goldAnnoationsComparable.size();
            this.dictTP += 0;
            this.dictFN += goldAnnoationsComparable.size();
            this.bothTP += 0;
        }
    }

    @Override
    public void destroy() {
        System.out.println("#goldstandard:\t" + this.GA);
        System.out.println("#pipeline:\t" + this.PA);
        System.out.println("#dict:\t\t" + this.dictA);
        System.out.println("#crf:\t\t" + this.crfA);
        System.out.println();
        System.out.println("TP\tCRF\t" + this.crfTP);
        System.out.println("FN\tCRF\t" + this.crfFN);
        System.out.println("R\tCRF\t" + (double)this.crfTP / ((double)this.crfTP + (double)this.crfFN));
        System.out.println("TP\tDICT\t" + this.dictTP);
        System.out.println("FN\tDICT\t" + this.dictFN);
        System.out.println("R\tDICT\t" + (double)this.dictTP / ((double)this.dictTP + (double)this.dictFN));
        System.out.println("TP\tBOTH\t" + this.bothTP);
        System.out.println();
    }
}

