/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.cc.eval;

import de.berlin.hu.uima.cc.eval.ComparableAnnotation;
import de.berlin.hu.wbi.common.research.Evaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.u_compare.shared.semantic.NamedEntity;

public class Evaluation
extends CasConsumer_ImplBase {
    private int GA = 0;
    private int PA = 0;
    private int TP = 0;
    private int FP = 0;
    private int FN = 0;
    private int GATest;
    private int PATest;
    private int numberOfSentences;

    @Override
    public void initialize() throws ResourceInitializationException {
        super.initialize();
    }

    @Override
    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas aJCas;
        ArrayList<NamedEntity> goldAnnotations = new ArrayList<NamedEntity>();
        ArrayList<NamedEntity> pipelineAnnotations = new ArrayList<NamedEntity>();
        try {
            aJCas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException(e);
        }
        AnnotationIndex<Annotation> namedEntityIndex = aJCas.getAnnotationIndex(NamedEntity.type);
        for (NamedEntity namedEntity : namedEntityIndex) {
            if ("goldstandard".equals(namedEntity.getSource())) {
                goldAnnotations.add(namedEntity);
                continue;
            }
            pipelineAnnotations.add(namedEntity);
        }
        this.evaluate(goldAnnotations, pipelineAnnotations, 0);
    }

    public void evaluate(List<NamedEntity> goldAnnotations, List<NamedEntity> pipelineAnnotations, int offset) {
        ArrayList<ComparableAnnotation> goldAnnotationsComparable = new ArrayList<ComparableAnnotation>();
        ArrayList<ComparableAnnotation> pipelineAnnotationsComparable = new ArrayList<ComparableAnnotation>();
        this.GATest += goldAnnotations.size();
        this.PATest += pipelineAnnotations.size();
        for (NamedEntity namedEntity : goldAnnotations) {
            goldAnnotationsComparable.add(ComparableAnnotation.createInstance(namedEntity.getBegin(), namedEntity.getEnd(), namedEntity.getCoveredText(), offset, namedEntity.getCAS()));
        }
        for (NamedEntity namedEntity : pipelineAnnotations) {
            pipelineAnnotationsComparable.add(ComparableAnnotation.createInstance(namedEntity.getBegin(), namedEntity.getEnd(), namedEntity.getCoveredText(), offset, namedEntity.getCAS()));
        }
        this.GA += goldAnnotationsComparable.size();
        this.PA += pipelineAnnotationsComparable.size();
        assert (this.GATest == this.GA);
        assert (this.PATest == this.PA);
        if (goldAnnotationsComparable.size() == 0) {
            this.FP += pipelineAnnotationsComparable.size();
        } else if (pipelineAnnotationsComparable.size() == 0) {
            this.FN += goldAnnotationsComparable.size();
        } else {
            Evaluator evaluator = new Evaluator(pipelineAnnotationsComparable, goldAnnotationsComparable);
            evaluator.evaluate();
            this.TP += evaluator.getTruePositives().size();
            this.FP += evaluator.getFalsePositives().size();
            this.FN += evaluator.getFalseNegatives().size();
            Collection FPs = evaluator.getFalsePositives();
            ArrayList listFPs = new ArrayList(FPs);
            Collections.shuffle(listFPs);
            List sampleFPs = listFPs.subList(0, Math.min(50, listFPs.size()));
            Collection FNs = evaluator.getFalseNegatives();
            ArrayList listFNs = new ArrayList(FNs);
            Collections.shuffle(listFNs);
            List list2 = listFNs.subList(0, Math.min(50, listFNs.size()));
        }
    }

    @Override
    public void destroy() {
        System.out.println("#Sentences:" + this.numberOfSentences);
        System.out.println("#Goldstandard Annotations:" + this.GA + "->" + this.GATest);
        System.out.println("#Pipeline Annotations:" + this.PA + "->" + this.PATest);
        System.out.println("### RESULTS ###");
        System.out.format("TP:\t%d\nFP:\t%d\nFN:\t%d\n", this.TP, this.FP, this.FN);
        System.out.println();
        double precision = (double)this.TP / ((double)this.TP + (double)this.FP);
        double recall2 = (double)this.TP / ((double)this.TP + (double)this.FN);
        double fscore = 2.0 * (precision * recall2) / (precision + recall2);
        System.out.format("precision:\t%f\nrecall:\t%f\nf-score:\t%f\n", precision, recall2, fscore);
        System.out.println();
    }
}

