/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.drug;

import de.berlin.hu.eumed.EntityTagger;
import de.berlin.hu.types.PubmedDocument;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.u_compare.shared.semantic.Chemical;
import org.uimafit.util.JCasUtil;
import scala.Tuple2;
import scala.collection.Iterator;
import simplexnlp.core.Annotation;
import simplexnlp.core.Child;
import simplexnlp.core.Document;
import simplexnlp.core.Entity;
import simplexnlp.core.Sentence;
import simplexnlp.core.Token;

public class DrugNERTagger
extends JCasAnnotator_ImplBase {
    public static final String PATH_TO_DRUG_MODEL = "pathToDrugModel";
    private EntityTagger tagger = null;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        String drugModel = (String)aContext.getConfigParameterValue(PATH_TO_DRUG_MODEL);
        this.tagger = new EntityTagger();
        this.tagger.add(new Tuple2<String, String>("path", drugModel));
        this.tagger.initialize();
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        Iterable<PubmedDocument> documents = JCasUtil.iterate(aJCas, PubmedDocument.class);
        for (PubmedDocument doc : documents) {
            String docId = doc.getPmid();
            Document simplexDoc = new Document(docId, doc.getCoveredText());
            Iterable<org.u_compare.shared.syntactic.Sentence> sentences = JCasUtil.iterate(aJCas, org.u_compare.shared.syntactic.Sentence.class);
            int i = 0;
            for (org.u_compare.shared.syntactic.Sentence sentence : sentences) {
                simplexnlp.example.Sentence simplexSentence = new simplexnlp.example.Sentence(sentence.getBegin(), sentence.getEnd() - 1);
                simplexSentence.id_$eq(String.valueOf(docId) + ".s" + i++);
                simplexSentence.origId_$eq(simplexSentence.id());
                simplexDoc.add((Child)simplexSentence);
                List<org.u_compare.shared.syntactic.Token> tokens = JCasUtil.selectCovered(aJCas, org.u_compare.shared.syntactic.Token.class, sentence);
                for (org.u_compare.shared.syntactic.Token token2 : tokens) {
                    Token simplexToken = new Token(token2.getBegin() - sentence.getBegin(), token2.getEnd() - sentence.getBegin() - 1);
                    simplexToken.pos_$eq(token2.getLabel());
                    simplexSentence.add((Annotation)simplexToken);
                }
            }
            this.tagger.process(simplexDoc);
            Iterator simplexSentences = simplexDoc.sentences().toIterator();
            while (simplexSentences.hasNext()) {
                Sentence sentence = (Sentence)simplexSentences.next();
                Iterator entities = sentence.entities().toIterator();
                while (entities.hasNext()) {
                    Entity entity = (Entity)entities.next();
                    this.createDrugAnnotation(aJCas, sentence.start() + entity.start(), sentence.start() + entity.end() + 1);
                }
            }
        }
    }

    private Chemical createDrugAnnotation(JCas aJCas, int begin, int end) {
        Chemical drug = new Chemical(aJCas);
        drug.setBegin(begin);
        drug.setEnd(end);
        drug.setSource("drug tagger");
        drug.addToIndexes();
        System.out.println("'" + drug.getCoveredText() + "'");
        return drug;
    }
}

