/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.tagger.abbrev;

import de.berlin.hu.chemspot.Mention;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtractAbbrev {
    Map<String, Vector<String>> mTestDefinitions = new HashMap<String, Vector<String>>();
    Map<String, Vector<String>> mStats = new HashMap<String, Vector<String>>();
    int truePositives = 0;
    int falsePositives = 0;
    int falseNegatives = 0;
    int trueNegatives = 0;
    char delimiter = (char)9;
    boolean testMode = false;

    private boolean isValidShortForm(String str) {
        return this.hasLetter(str) && (Character.isLetterOrDigit(str.charAt(0)) || str.charAt(0) == '(');
    }

    private boolean hasLetter(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isLetter(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCapital(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isUpperCase(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void loadTrueDefinitions(String inFile) {
        String str = "";
        Map<String, Vector<String>> definitions = this.mTestDefinitions;
        try {
            BufferedReader fin = new BufferedReader(new FileReader(inFile));
            while ((str = fin.readLine()) != null) {
                int j = str.indexOf(this.delimiter);
                String abbrString = str.substring(0, j).trim();
                String defnString = str.substring(j, str.length()).trim();
                Vector<String> entry = definitions.get(abbrString);
                if (entry == null) {
                    entry = new Vector();
                }
                entry.add(defnString);
                definitions.put(abbrString, entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(str);
        }
    }

    private boolean isTrueDefinition(String shortForm, String longForm) {
        Vector<String> entry = this.mTestDefinitions.get(shortForm);
        if (entry == null) {
            return false;
        }
        Iterator<String> itr = entry.iterator();
        while (itr.hasNext()) {
            if (!itr.next().toString().equalsIgnoreCase(longForm)) continue;
            return true;
        }
        return false;
    }

    private String readFromFile(String file) throws IOException {
        FileInputStream stream = new FileInputStream(new File(file));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string2 = Charset.defaultCharset().decode(bb).toString();
            return string2;
        }
        finally {
            stream.close();
        }
    }

    public List<Mention> getMentionsFromFile(String inFile) throws IOException {
        try {
            return this.getMentions(this.readFromFile(inFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new ArrayList<Mention>();
        }
    }

    public List<Mention> getMentions(String text2) {
        String longForm = "";
        String shortForm = "";
        String currSentence = "";
        int closeParenIndex = -1;
        int tmpIndex = -1;
        ArrayList<Mention> result2 = new ArrayList<Mention>();
        try {
            int offset = 0;
            currSentence = text2;
            int openParenIndex = currSentence.indexOf(" (");
            do {
                int begin = 0;
                int end = 0;
                if (openParenIndex > -1) {
                    ++openParenIndex;
                }
                int sentenceEnd = Math.max(currSentence.lastIndexOf(". "), currSentence.lastIndexOf(", "));
                if (openParenIndex != -1 || sentenceEnd != -1) {
                    if (openParenIndex == -1) {
                        currSentence = currSentence.substring(sentenceEnd + 2);
                        offset = sentenceEnd + 2;
                    } else {
                        closeParenIndex = currSentence.indexOf(41, openParenIndex);
                        if (closeParenIndex > -1) {
                            sentenceEnd = Math.max(currSentence.lastIndexOf(". ", openParenIndex), currSentence.lastIndexOf(", ", openParenIndex));
                            if (sentenceEnd == -1) {
                                sentenceEnd = -2;
                            }
                            longForm = currSentence.substring(sentenceEnd + 2, openParenIndex);
                            shortForm = currSentence.substring(openParenIndex + 1, closeParenIndex);
                            begin = openParenIndex + 1;
                            end = closeParenIndex;
                        }
                    }
                }
                if (shortForm.length() > 0 || longForm.length() > 0) {
                    if (shortForm.length() > 1 && longForm.length() > 1) {
                        StringTokenizer shortTokenizer;
                        int newCloseParenIndex;
                        if (shortForm.indexOf(40) > -1 && (newCloseParenIndex = currSentence.indexOf(41, closeParenIndex + 1)) > -1) {
                            shortForm = currSentence.substring(openParenIndex + 1, newCloseParenIndex);
                            closeParenIndex = newCloseParenIndex;
                            begin = openParenIndex + 1;
                            end = closeParenIndex;
                        }
                        if ((tmpIndex = shortForm.indexOf(", ")) > -1) {
                            shortForm = shortForm.substring(0, tmpIndex);
                            end = begin + tmpIndex;
                        }
                        if ((tmpIndex = shortForm.indexOf("; ")) > -1) {
                            shortForm = shortForm.substring(0, tmpIndex);
                            end = begin + tmpIndex;
                        }
                        if ((shortTokenizer = new StringTokenizer(shortForm)).countTokens() > 2 || shortForm.length() > longForm.length()) {
                            tmpIndex = currSentence.lastIndexOf(" ", openParenIndex - 2);
                            String tmpStr = currSentence.substring(tmpIndex + 1, openParenIndex - 1);
                            longForm = shortForm;
                            shortForm = tmpStr;
                            begin = tmpIndex + 1;
                            end = openParenIndex - 1;
                            if (!this.hasCapital(shortForm)) {
                                shortForm = "";
                            }
                        }
                        if (this.isValidShortForm(shortForm)) {
                            String abbreviation = currSentence.substring(begin, end);
                            String bestLongForm = this.extractAbbrPair(shortForm.trim(), longForm.trim());
                            if (bestLongForm != null && !bestLongForm.isEmpty()) {
                                Mention mention = new Mention(begin += offset, end += offset, abbreviation, bestLongForm, "ABBREV", null);
                                result2.add(mention);
                            }
                        }
                    }
                    currSentence = currSentence.substring(closeParenIndex + 1);
                    offset += closeParenIndex + 1;
                } else if (openParenIndex > -1) {
                    if (currSentence.length() - openParenIndex > 200) {
                        currSentence = currSentence.substring(openParenIndex + 1);
                    }
                    break;
                }
                shortForm = "";
                longForm = "";
            } while ((openParenIndex = currSentence.indexOf(" (")) > -1);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            System.out.println(currSentence);
            System.out.println(tmpIndex);
        }
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    private String findBestLongForm(String shortForm, String longForm) {
        sIndex = shortForm.length() - 1;
        lIndex = longForm.length() - 1;
        while (sIndex >= 0) {
            block3: {
                currChar = Character.toLowerCase(shortForm.charAt(sIndex));
                if (Character.isLetterOrDigit(currChar)) ** GOTO lbl8
                break block3;
lbl-1000:
                // 1 sources

                {
                    --lIndex;
lbl8:
                    // 2 sources

                    ** while (lIndex >= 0 && Character.toLowerCase((char)longForm.charAt((int)lIndex)) != currChar || sIndex == 0 && lIndex > 0 && Character.isLetterOrDigit((char)longForm.charAt((int)(lIndex - 1))))
                }
lbl9:
                // 1 sources

                if (lIndex < 0) {
                    return null;
                }
                --lIndex;
            }
            --sIndex;
        }
        lIndex = longForm.lastIndexOf(" ", lIndex) + 1;
        return longForm.substring(lIndex);
    }

    private String extractAbbrPair(String shortForm, String longForm) {
        if (shortForm.length() == 1) {
            return null;
        }
        String bestLongForm = this.findBestLongForm(shortForm, longForm);
        if (bestLongForm == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(bestLongForm, " \t\n\r\f-");
        int longFormSize = tokenizer.countTokens();
        int shortFormSize = shortForm.length();
        int i = shortFormSize - 1;
        while (i >= 0) {
            if (!Character.isLetterOrDigit(shortForm.charAt(i))) {
                --shortFormSize;
            }
            --i;
        }
        if (bestLongForm.length() < shortForm.length() || bestLongForm.indexOf(String.valueOf(shortForm) + " ") > -1 || bestLongForm.endsWith(shortForm) || longFormSize > shortFormSize * 2 || longFormSize > shortFormSize + 5 || shortFormSize > 10) {
            return null;
        }
        if (this.testMode) {
            if (this.isTrueDefinition(shortForm, bestLongForm)) {
                System.out.println(String.valueOf(shortForm) + this.delimiter + bestLongForm + this.delimiter + "TP");
                ++this.truePositives;
            } else {
                ++this.falsePositives;
                System.out.println(String.valueOf(shortForm) + this.delimiter + bestLongForm + this.delimiter + "FP");
            }
        } else {
            return bestLongForm;
        }
        return "";
    }

    private static void usage() {
        System.err.println("Usage: ExtractAbbrev [-options] <filename>");
        System.err.println("       <filename> contains text from which abbreviations are extracted");
        System.err.println("       -testlist <file> = list of true abbreviation definition pairs");
        System.err.println("       -usage or -help = this message");
        System.exit(1);
    }

    public static void main(String[] args) {
        ExtractAbbrev extractAbbrev = new ExtractAbbrev();
        String filename = null;
        String testList = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testlist")) {
                if (i == args.length - 1) {
                    ExtractAbbrev.usage();
                }
                testList = args[++i];
                extractAbbrev.testMode = true;
            } else if (args[i].equals("-usage")) {
                ExtractAbbrev.usage();
            } else if (args[i].equals("-help")) {
                ExtractAbbrev.usage();
            } else {
                filename = args[i];
                if (i != args.length - 1) {
                    ExtractAbbrev.usage();
                }
            }
            ++i;
        }
        if (filename == null) {
            ExtractAbbrev.usage();
        }
        if (extractAbbrev.testMode) {
            extractAbbrev.loadTrueDefinitions(testList);
        }
        extractAbbrev.getMentions(filename);
        if (extractAbbrev.testMode) {
            System.out.println("TP: " + extractAbbrev.truePositives + " FP: " + extractAbbrev.falsePositives + " FN: " + extractAbbrev.falseNegatives + " TN: " + extractAbbrev.trueNegatives);
        }
    }
}

