/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.u_compare.shared.semantic.NamedEntity;

public class SuffixFilter
extends JCasAnnotator_ImplBase {
    private int numberOfFilteredEntities = 0;
    private List<NamedEntity> invalidChemicals = null;
    private String[] invalidSuffixes = new String[]{"ase"};

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        AnnotationIndex<Annotation> chemicalIndex = aJCas.getAnnotationIndex(NamedEntity.type);
        FSIterator chemicalIterator = chemicalIndex.iterator();
        this.invalidChemicals = new ArrayList<NamedEntity>();
        while (chemicalIterator.hasNext()) {
            NamedEntity chemical = (NamedEntity)chemicalIterator.next();
            if ("goldstandard".equals(chemical.getSource()) || !this.isInvalid(chemical.getCoveredText())) continue;
            this.invalidChemicals.add(chemical);
            ++this.numberOfFilteredEntities;
        }
        for (NamedEntity invalidChemical : this.invalidChemicals) {
            invalidChemical.removeFromIndexes();
        }
    }

    private boolean isInvalid(String entity) {
        String suffix;
        return entity.length() > 2 && this.isInvalidSuffix(suffix = (String)entity.subSequence(entity.length() - 3, entity.length()));
    }

    private boolean isInvalidSuffix(String suffix) {
        int i = 0;
        while (i < this.invalidSuffixes.length) {
            if (this.invalidSuffixes[i].equals(suffix)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

