/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.u_compare.shared.semantic.NamedEntity;

public class StopwordFilter
extends JCasAnnotator_ImplBase {
    private List<NamedEntity> invalidChemicals = null;
    private HashSet<String> stopwords = new HashSet();

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        InputStream stopwordFile = this.getClass().getClassLoader().getResourceAsStream("resources/chemspot_stop_words.txt");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stopwordFile));
            String line = "";
            while ((line = reader.readLine()) != null) {
                this.stopwords.add(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException(e);
        }
        catch (IOException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        AnnotationIndex<Annotation> chemicalIndex = aJCas.getAnnotationIndex(NamedEntity.type);
        FSIterator chemicalIterator = chemicalIndex.iterator();
        this.invalidChemicals = new ArrayList<NamedEntity>();
        while (chemicalIterator.hasNext()) {
            NamedEntity chemical = (NamedEntity)chemicalIterator.next();
            if ("goldstandard".equals(chemical.getSource()) || !this.stopwords.contains(chemical.getCoveredText().toLowerCase())) continue;
            this.invalidChemicals.add(chemical);
        }
        for (NamedEntity invalidChemical : this.invalidChemicals) {
            invalidChemical.removeFromIndexes();
        }
    }
}

