/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.uima.ae.feature;

import de.berlin.hu.chemspot.ChemSpot;
import de.berlin.hu.types.PubmedDocument;
import de.berlin.hu.uima.ae.feature.FeatureToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.uimafit.factory.JCasFactory;

public class FeatureGeneratorApp {
    private static ChemSpot chemspot = null;
    private static TypeSystemDescription typeSystem = null;
    private static Map<Long, JCas> jCases = new HashMap<Long, JCas>();

    public static void initialize(String pathToDictionaryFile, String pathToIDsFile) {
        chemspot = new ChemSpot(null, pathToDictionaryFile, null, pathToIDsFile, null);
        try {
            typeSystem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(chemspot.getClass().getClassLoader().getResource("desc/TypeSystem.xml")));
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FeatureToken> generateFeatureTokens(String text2) {
        long threadId = Thread.currentThread().getId();
        if (!jCases.containsKey(threadId)) {
            Map<Long, JCas> map2 = jCases;
            synchronized (map2) {
                try {
                    jCases.put(threadId, JCasFactory.createJCas(typeSystem));
                }
                catch (UIMAException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        JCas jcas = jCases.get(threadId);
        jcas.reset();
        jcas.setDocumentText(text2);
        PubmedDocument pd = new PubmedDocument(jcas);
        pd.setBegin(0);
        pd.setEnd(text2.length());
        pd.setPmid("");
        pd.addToIndexes(jcas);
        chemspot.tag(jcas);
        System.out.println(ChemSpot.serializeAnnotations(jcas));
        return chemspot.getFeatureTokenGenerator().getFeatureTokens(jcas);
    }

    public static void main(String[] args) throws InvalidXMLException, IOException {
        String pathToDictionaryFile = null;
        String pathToIDsFile = null;
        String text2 = "A serum of 18-bromo-12-butyl-11-bromo-4,8-diethyl-5-hydroxy is great for combination with aspirin and Lysophosphatidate as well as LoseC and associated names and Antidiarrheals.";
        FeatureGeneratorApp.initialize(pathToDictionaryFile, pathToIDsFile);
        List<FeatureToken> featureTokens = FeatureGeneratorApp.generateFeatureTokens(text2);
        for (FeatureToken token2 : featureTokens) {
            System.out.printf("%d-%d\t%s\t%s%n", token2.getBegin(), token2.getEnd(), token2.getCoveredText(), token2.getFeatures().toString());
        }
    }
}

