/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.chemspot;

import de.berlin.hu.chemspot.ChemSpot;
import de.berlin.hu.chemspot.Mention;
import de.berlin.hu.wbi.common.research.Evaluator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;

public class ChemicalNEREvaluator {
    private int TP = 0;
    private int FP = 0;
    private int FN = 0;
    private Object evaluationLock = new Object();
    private List<Mention> truePositives = new ArrayList<Mention>();
    private List<Mention> falsePositives = new ArrayList<Mention>();
    private List<Mention> falseNegatives = new ArrayList<Mention>();
    private List<Mention> goldstandard = new ArrayList<Mention>();
    private List<Mention> normalizedAll = new ArrayList<Mention>();
    private List<Mention> normalized = new ArrayList<Mention>();
    private List<Mention> normalizedCorrect = new ArrayList<Mention>();
    private Object normalizationLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(JCas jcas) {
        System.out.println("Starting evaluation...");
        List<Mention> mentions = ChemSpot.getMentions(jcas);
        List<Mention> goldstandardAnnotations = ChemSpot.getGoldstandardAnnotations(jcas);
        this.goldstandard.addAll(goldstandardAnnotations);
        Object object = this.evaluationLock;
        synchronized (object) {
            if (goldstandardAnnotations.size() == 0) {
                this.FP += mentions.size();
                this.falsePositives.addAll(mentions);
            } else if (mentions.size() == 0) {
                this.FN += goldstandardAnnotations.size();
                this.falseNegatives.addAll(goldstandardAnnotations);
            } else {
                Evaluator<Mention, Mention> evaluator = new Evaluator<Mention, Mention>(mentions, goldstandardAnnotations);
                evaluator.evaluate();
                this.TP += evaluator.getTruePositives().size();
                this.FP += evaluator.getFalsePositives().size();
                this.FN += evaluator.getFalseNegatives().size();
                this.truePositives.addAll(evaluator.getTruePositives());
                this.falsePositives.addAll(evaluator.getFalsePositives());
                this.falseNegatives.addAll(evaluator.getFalseNegatives());
                this.evaluateNormalization(new ArrayList<Mention>(evaluator.getTruePositives()), goldstandardAnnotations);
                System.out.format("True Positives:\t\t%d\nFalse Positives:\t%d\nFalse Negatives:\t%d\n", this.TP, this.FP, this.FN);
                double precision = (double)this.TP / ((double)this.TP + (double)this.FP);
                double recall2 = (double)this.TP / ((double)this.TP + (double)this.FN);
                double fscore = precision + recall2 > 0.0 ? 2.0 * (precision * recall2) / (precision + recall2) : 0.0;
                System.out.format("Precision:\t\t%f\nRecall:\t\t\t%f\nF1 Score:\t\t%f\n", precision, recall2, fscore);
                if (!this.normalized.isEmpty()) {
                    double correctAllRatio = !this.normalizedAll.isEmpty() ? (double)this.normalizedCorrect.size() / (double)this.normalizedAll.size() : 0.0;
                    double correctNormalizedRatio = !this.normalized.isEmpty() ? (double)this.normalizedCorrect.size() / (double)this.normalized.size() : 0.0;
                    System.out.format("%d of %d entities were normalized, %d correctly (%.2f %% of all and %.2f %% of normalized)%n", this.normalized.size(), this.normalizedAll.size(), this.normalizedCorrect.size(), correctAllRatio * 100.0, correctNormalizedRatio * 100.0);
                }
                System.out.println();
            }
        }
    }

    private void evaluateByType(List<Mention> tps, List<Mention> goldstandard) {
        HashMap mapTypeToGoldstandard = new HashMap();
        for (Mention goldstandardMention : goldstandard) {
            String type = goldstandardMention.getType();
            if (type == null || type.isEmpty()) continue;
            if (!mapTypeToGoldstandard.containsKey(type)) {
                mapTypeToGoldstandard.put(type, new ArrayList());
            }
            ((List)mapTypeToGoldstandard.get(type)).add(goldstandardMention);
        }
        System.out.println();
        if (!mapTypeToGoldstandard.isEmpty()) {
            for (String type : mapTypeToGoldstandard.keySet()) {
                List typeGoldstandard = (List)mapTypeToGoldstandard.get(type);
                ArrayList<Mention> typeTruePositives = new ArrayList<Mention>(tps);
                typeTruePositives.retainAll(typeGoldstandard);
                int typeTPs = typeTruePositives.size();
                int typeAll = typeGoldstandard.size();
                double precision = typeAll != 0 ? (double)typeTPs / (double)typeAll : 0.0;
                System.out.printf("%s - TPs: %d, All: %d, precision: %.4f %%%n", type, typeTPs, typeAll, precision * 100.0);
            }
        }
    }

    private double evaluateNormalization(List<Mention> tps, List<Mention> goldStandard) {
        Collections.sort(tps);
        Collections.sort(goldStandard);
        int i = 0;
        for (Mention m : tps) {
            Mention s;
            while (i < goldStandard.size() && goldStandard.get(i).getStart() < m.getStart()) {
                ++i;
            }
            if (goldStandard.get(i).getStart() != m.getStart() || (s = goldStandard.get(i)).getCHEB() == null) continue;
            this.normalizedAll.add(s);
            if (m.getCHEB() == null || m.getCHEB().isEmpty()) continue;
            this.normalized.add(m);
            if (m.getCHEB().equals(s.getCHEB())) {
                this.normalizedCorrect.add(m);
                continue;
            }
            m.setCHEB(String.format("%s (correct: %s)", m.getCHEB(), s.getCHEB()));
        }
        return !this.normalizedAll.isEmpty() ? (double)this.normalizedCorrect.size() / (double)this.normalizedAll.size() : 0.0;
    }

    private static List<List<Mention>> sortMentionListsBySize(List<Mention> list2, boolean bySource) {
        ArrayList<List<Mention>> result2 = new ArrayList<List<Mention>>();
        HashMap annotationMap = new HashMap();
        for (Mention mention : list2) {
            String key;
            String string2 = key = bySource ? mention.getSource() : mention.getText().toLowerCase();
            if (!annotationMap.containsKey(key)) {
                annotationMap.put(key, new ArrayList());
            }
            ((List)annotationMap.get(key)).add(mention);
        }
        for (String key : annotationMap.keySet()) {
            result2.add((List)annotationMap.get(key));
        }
        Comparator<List<Mention>> comparator = new Comparator<List<Mention>>(){

            @Override
            public int compare(List<Mention> o1, List<Mention> o2) {
                return o1.size() - o2.size();
            }
        };
        Collections.sort(result2, Collections.reverseOrder(comparator));
        return result2;
    }

    private static void writeOverlapping(OutputStream s, String name1, List<Mention> list1, String name2, List<Mention> list2) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(s));
        list1 = new ArrayList<Mention>(list1);
        Collections.sort(list1);
        list2 = new ArrayList<Mention>(list2);
        Collections.sort(list2);
        Pattern startPattern = Pattern.compile("(\\S+\\s+){5}\\S*$");
        Pattern stopPattern = Pattern.compile("^\\S*(\\s+\\S+){5}");
        writer.write(String.format("Overlapping occurrences of <%s> and [%s]:%n%n", name1, name2));
        int maxLength = 100;
        int i = 0;
        for (Mention m1 : list1) {
            while (i < list2.size() && list2.get(i).getEnd() < m1.getStart()) {
                ++i;
            }
            int j = i;
            while (j < list2.size() && list2.get(j).overlaps(m1)) {
                Mention m2 = list2.get(j++);
                if (!m1.getDocumentText().equals(m2.getDocumentText())) continue;
                String text2 = m1.getDocumentText();
                int begin = Math.min(m1.getStart(), m2.getStart());
                int end = Math.max(m1.getEnd(), m2.getEnd());
                Matcher matcher = startPattern.matcher(text2.substring(Math.max(begin - maxLength, 0), begin));
                int start = matcher.find() ? Math.max(begin - maxLength, 0) + matcher.start() : Math.max(begin - 30, 0);
                matcher = stopPattern.matcher(text2.substring(end, Math.min(end + maxLength, text2.length())));
                int stop = matcher.find() ? end + matcher.end() : Math.min(end + 30, text2.length());
                StringBuilder sb = new StringBuilder();
                sb.append(text2.substring(start, stop));
                sb.insert(m1.getStart() - start, '<');
                sb.insert(m1.getEnd() - start + 1, '>');
                sb.insert(m2.getStart() - start + (m1.getStart() < m2.getStart() ? 1 : 0) + (m1.getStart() == m2.getStart() && m1.getEnd() > m2.getEnd() ? 1 : 0), "[");
                sb.insert(m2.getEnd() - start + 2 + (m1.getEnd() < m2.getEnd() || m1.getEnd() == m2.getEnd() && m1.getStart() > m2.getStart() ? 1 : 0), "]").toString();
                writer.write("..." + sb.toString().replaceAll("\r?\n", "\\\\n") + "...");
                writer.newLine();
            }
        }
        writer.flush();
    }

    private static void writeList(OutputStream s, String name, List<Mention> list2) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(s));
        List<List<Mention>> listBySize = ChemicalNEREvaluator.sortMentionListsBySize(list2, false);
        writer.write(String.format("%n%n%n%s:%n", name));
        writer.write(String.format("%8s\t%25s\t%30s\t%s%n", "#", "CHEMICAL", "SOURCE", "ChEBI ID"));
        for (List<Mention> annotationList : listBySize) {
            List<List<Mention>> listBySource = ChemicalNEREvaluator.sortMentionListsBySize(annotationList, true);
            String sources = "";
            for (List<Mention> sourceList : listBySource) {
                Object source = !sourceList.isEmpty() ? sourceList.get(0).getSource() : "";
                Object object = source = source == null || ((String)source).isEmpty() ? "unknown" : source;
                source = listBySource.size() == 1 ? String.valueOf(sourceList.size() > 1 ? "all " : "") + (String)source : String.valueOf(sourceList.size()) + " " + (String)source;
                sources = String.valueOf(sources) + String.format("%s%s", !sources.isEmpty() ? ", " : "", source);
            }
            HashSet<String> ids = new HashSet<String>();
            for (Mention m : annotationList) {
                String id = m.getCHEB();
                if (id == null || id.trim().isEmpty() || "null".equals(id.trim()) || ids.contains(id.trim())) continue;
                ids.add(id.trim());
            }
            String idString = "";
            for (String id : ids) {
                idString = String.valueOf(idString) + ("".equals(idString) ? "" : ", ") + id;
            }
            String annotation = !annotationList.isEmpty() ? annotationList.get(0).getText() : "";
            writer.write(String.format("%8d\t%25s\t%30s\t%s%n", annotationList.size(), annotation, sources, idString));
        }
        writer.flush();
    }

    private static void writeContext(OutputStream s, String name, List<Mention> list2) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(s));
        List<List<Mention>> listBySize = ChemicalNEREvaluator.sortMentionListsBySize(list2, false);
        writer.write(String.format("%s:%n", name));
        Pattern startPattern = Pattern.compile("(\\S+\\s+){5}\\S*$");
        Pattern stopPattern = Pattern.compile("^\\S*(\\s+\\S+){5}");
        int maxLength = 100;
        block0: for (List<Mention> annotationList : listBySize) {
            if (annotationList.isEmpty()) continue;
            writer.write(String.format("%n%n%s (%d):%n", annotationList.get(0).getText(), annotationList.size()));
            int i = 0;
            for (Mention mention : annotationList) {
                if (i++ > 30) {
                    writer.write("...");
                    writer.newLine();
                    continue block0;
                }
                String text2 = null;
                text2 = mention.getDocumentText();
                int begin = mention.getStart();
                int end = mention.getEnd();
                Matcher matcher = startPattern.matcher(text2.substring(Math.max(begin - maxLength, 0), begin));
                int start = matcher.find() ? Math.max(begin - maxLength, 0) + matcher.start() : Math.max(begin - 30, 0);
                matcher = stopPattern.matcher(text2.substring(end, Math.min(end + maxLength, text2.length())));
                int stop = matcher.find() ? end + matcher.end() : Math.min(end + 30, text2.length());
                String output2 = String.format("...%s<%s>%s...", text2.substring(start, begin), text2.substring(begin, end), text2.substring(end, stop));
                output2 = output2.replaceAll("\r?\n", "\\\\n");
                writer.write(output2);
                writer.newLine();
            }
        }
        writer.flush();
    }

    public void writeNormalizations(OutputStream s, List<Mention> normalizedAll, List<Mention> normalized, List<Mention> normalizedCorrect) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(s));
        int normalizedAllCount = normalizedAll.size();
        int normalizedCount = normalized.size();
        int normalizedCorrectCount = normalizedCorrect.size();
        double correctAllRatio = normalizedAllCount != 0 ? (double)normalizedCorrect.size() / (double)normalizedAll.size() : 0.0;
        double precision = normalizedCount != 0 ? (double)normalizedCorrectCount / (double)normalizedCount : 0.0;
        double recall2 = normalizedCount != 0 ? (double)normalizedCount / (double)normalizedAllCount : 0.0;
        double fScore = precision != 0.0 || recall2 != 0.0 ? 2.0 * precision * recall2 / (precision + recall2) : 0.0;
        w.write(String.format("entities total              : %d%n", normalizedAllCount));
        w.write(String.format("entities normalized         : %d%n", normalizedCount));
        w.write(String.format("normalized correct          : %d%n", normalizedCorrectCount));
        w.write(String.format("percent correct (all)       : %.2f %%%n%n", correctAllRatio * 100.0));
        w.write(String.format("precision: %.2f %%%n", precision * 100.0));
        w.write(String.format("recall: %.2f %%%n", recall2 * 100.0));
        w.write(String.format("f1 score: %.2f %%%n", fScore * 100.0));
        w.flush();
        ChemicalNEREvaluator.writeList(s, "correct", normalizedCorrect);
        ArrayList<Mention> normalizedIncorrect = new ArrayList<Mention>(normalized);
        normalizedIncorrect.removeAll(normalizedCorrect);
        ChemicalNEREvaluator.writeList(s, "incorrect", normalizedIncorrect);
        ArrayList<Mention> notNormalized = new ArrayList<Mention>(normalizedAll);
        notNormalized.removeAll(normalizedCorrect);
        notNormalized.removeAll(normalizedIncorrect);
        ChemicalNEREvaluator.writeList(s, "not normalized", notNormalized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDetailedEvaluationResults(String outputPath) throws IOException {
        Object object = this.evaluationLock;
        synchronized (object) {
            this.evaluateByType(this.truePositives, this.goldstandard);
            if (outputPath == null) {
                outputPath = "";
            }
            File evaluationFile = new File(String.valueOf(outputPath) + "evaluation.txt");
            FileOutputStream writer = new FileOutputStream(evaluationFile);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(writer));
            w.write(String.format("True Positives:\t\t%d%nFalse Positives:\t%d%nFalse Negatives:\t%d%n", this.TP, this.FP, this.FN));
            double precision = (double)this.TP / ((double)this.TP + (double)this.FP);
            double recall2 = (double)this.TP / ((double)this.TP + (double)this.FN);
            double fscore = precision + recall2 > 0.0 ? 2.0 * (precision * recall2) / (precision + recall2) : 0.0;
            w.write(String.format("Precision:\t\t%f%nRecall:\t\t\t%f%nF1 Score:\t\t%f%n", precision, recall2, fscore));
            w.flush();
            ChemicalNEREvaluator.writeList(writer, "true positives", this.truePositives);
            ChemicalNEREvaluator.writeList(writer, "false negatives", this.falseNegatives);
            ChemicalNEREvaluator.writeList(writer, "false positives", this.falsePositives);
            w.close();
            ((OutputStream)writer).close();
            System.out.println("Evaluation results written to: " + evaluationFile.getName());
            File falsePositivesFile = new File(String.valueOf(outputPath) + "evaluation-FPs.txt");
            writer = new FileOutputStream(falsePositivesFile);
            ChemicalNEREvaluator.writeContext(writer, "false positives contexts", this.falsePositives);
            ((OutputStream)writer).close();
            System.out.println("False positive contexts written to: " + falsePositivesFile.getName());
            File falseNegativesFile = new File(String.valueOf(outputPath) + "evaluation-FNs.txt");
            writer = new FileOutputStream(falseNegativesFile);
            ChemicalNEREvaluator.writeContext(writer, "false negatives contexts", this.falseNegatives);
            ((OutputStream)writer).close();
            System.out.println("False negative contexts written to: " + falseNegativesFile.getName());
            File falsePositivesNegativesFile = new File(String.valueOf(outputPath) + "evaluation-overlappings-FPs-FNs.txt");
            writer = new FileOutputStream(falsePositivesNegativesFile);
            ChemicalNEREvaluator.writeOverlapping(writer, "false negatives", this.falseNegatives, "false positives", this.falsePositives);
            ((OutputStream)writer).close();
            System.out.println("Overlapping occurrences of false positives and negatives written to: " + falsePositivesNegativesFile.getName());
            Object object2 = this.normalizationLock;
            synchronized (object2) {
                if (!this.normalized.isEmpty()) {
                    File normalizedFile = new File(String.valueOf(outputPath) + "normalizations.txt");
                    writer = new FileOutputStream(normalizedFile);
                    this.writeNormalizations(writer, this.normalizedAll, this.normalized, this.normalizedCorrect);
                    ((OutputStream)writer).close();
                    System.out.println("Normalized entities written to: " + normalizedFile.getName());
                }
            }
        }
    }

    public int getTP() {
        return this.TP;
    }

    public void setTP(int tP) {
        this.TP = tP;
    }

    public int getFP() {
        return this.FP;
    }

    public void setFP(int fP) {
        this.FP = fP;
    }

    public int getFN() {
        return this.FN;
    }

    public void setFN(int fN) {
        this.FN = fN;
    }

    public List<Mention> getTruePositives() {
        return this.truePositives;
    }

    public void setTruePositives(List<Mention> truePositives) {
        this.truePositives = truePositives;
    }

    public List<Mention> getFalsePositives() {
        return this.falsePositives;
    }

    public void setFalsePositives(List<Mention> falsePositives) {
        this.falsePositives = falsePositives;
    }

    public List<Mention> getFalseNegatives() {
        return this.falseNegatives;
    }

    public void setFalseNegatives(List<Mention> falseNegatives) {
        this.falseNegatives = falseNegatives;
    }

    public List<Mention> getNormalizedAll() {
        return this.normalizedAll;
    }

    public void setNormalizedAll(List<Mention> normalizedAll) {
        this.normalizedAll = normalizedAll;
    }

    public List<Mention> getNormalized() {
        return this.normalized;
    }

    public void setNormalized(List<Mention> normalized) {
        this.normalized = normalized;
    }

    public List<Mention> getNormalizedCorrect() {
        return this.normalizedCorrect;
    }

    public void setNormalizedCorrect(List<Mention> normalizedCorrect) {
        this.normalizedCorrect = normalizedCorrect;
    }
}

