/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.banner.featuresets;

import banner.tagging.FeatureSet;
import banner.tagging.TagFormat;
import banner.tagging.pipe.LChar;
import banner.tagging.pipe.LowerCaseTokenText;
import banner.tagging.pipe.RChar;
import banner.tagging.pipe.Sentence2TokenSequence;
import banner.types.Mention;
import banner.types.Sentence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureVectorSequence;
import cc.mallet.pipe.tsf.OffsetConjunctions;
import cc.mallet.pipe.tsf.RegexMatches;
import cc.mallet.pipe.tsf.TokenTextCharPrefix;
import cc.mallet.pipe.tsf.TokenTextCharSuffix;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;

public class KlingerLikeFeatureSet
extends FeatureSet {
    private static final long serialVersionUID = 3850553083981024255L;
    private SerialPipes pipe;
    private static final boolean USE_POS_AND_LEMMA = false;

    public KlingerLikeFeatureSet(TagFormat format2, Lemmatiser lemmatiser, Tagger posTagger, banner.tagging.Tagger preTagger, Set<Mention.MentionType> mentionTypes, Sentence.OverlapOption sameType, Sentence.OverlapOption differentType) {
        super(format2, lemmatiser, posTagger, preTagger, mentionTypes, sameType, differentType);
        this.pipe = this.createPipe(format2, lemmatiser, posTagger, preTagger, mentionTypes, sameType, differentType);
    }

    @Override
    public void setLemmatiser(Lemmatiser lemmatiser) {
    }

    @Override
    public void setPosTagger(Tagger posTagger) {
    }

    @Override
    public void setPreTagger(banner.tagging.Tagger preTagger) {
    }

    @Override
    public Pipe getPipe() {
        return this.pipe;
    }

    private SerialPipes createPipe(TagFormat format2, Lemmatiser lemmatiser, Tagger posTagger, banner.tagging.Tagger preTagger, Set<Mention.MentionType> mentionTypes, Sentence.OverlapOption sameType, Sentence.OverlapOption differentType) {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        pipes.add(new Sentence2TokenSequence(format2, mentionTypes, sameType, differentType));
        pipes.add(new LChar("LCHAR="));
        pipes.add(new RChar("RCHAR="));
        pipes.add(new LowerCaseTokenText("W="));
        pipes.add(new RegexMatches("ALLCAPS", Pattern.compile("[A-Z]+")));
        pipes.add(new RegexMatches("REALNUMBER", Pattern.compile("[-0-9]+[.,]+[0-9.,]+")));
        pipes.add(new RegexMatches("ISDASH", Pattern.compile("[-\u2013\u2014\u2212]")));
        pipes.add(new RegexMatches("ISQUOTE", Pattern.compile("[\u201e\u201c\u201d\u201d\u2018\u2019\"']")));
        pipes.add(new RegexMatches("ISSLASH", Pattern.compile("[/\\\\]")));
        pipes.add(new TokenTextCharPrefix("2PREFIX=", 2));
        pipes.add(new TokenTextCharSuffix("2SUFFIX=", 2));
        pipes.add(new OffsetConjunctions(new int[][]{{-2}, {-1}, {1}, {2}}));
        pipes.add(new TokenSequence2FeatureVectorSequence(true, true));
        return new SerialPipes(pipes);
    }
}

