/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPBinding sOAPBinding = (SOAPBinding)extensibilityElement;
        if (sOAPBinding != null) {
            String string2 = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "binding", definition);
            printWriter.print("    <" + string2);
            DOMUtils.printAttribute("style", sOAPBinding.getStyle(), printWriter);
            DOMUtils.printAttribute("transport", sOAPBinding.getTransportURI(), printWriter);
            Boolean bl = sOAPBinding.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPBinding sOAPBinding = (SOAPBinding)extensionRegistry.createExtension(clazz, qName);
        String string2 = DOMUtils.getAttribute(element, "transport");
        String string3 = DOMUtils.getAttribute(element, "style");
        String string4 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string2 != null) {
            sOAPBinding.setTransportURI(string2);
        }
        if (string3 != null) {
            sOAPBinding.setStyle(string3);
        }
        if (string4 != null) {
            sOAPBinding.setRequired(new Boolean(string4));
        }
        return sOAPBinding;
    }
}

