/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.resources.wn;

import java.io.FileInputStream;
import java.util.Iterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.relationship.AsymmetricRelationship;
import net.didion.jwnl.data.relationship.Relationship;
import net.didion.jwnl.data.relationship.RelationshipFinder;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.dictionary.Dictionary;

public class Examples {
    private static final String USAGE = "java Examples <properties file>";
    private IndexWord ACCOMPLISH = Dictionary.getInstance().getIndexWord(POS.VERB, "accomplish");
    private IndexWord DOG = Dictionary.getInstance().getIndexWord(POS.NOUN, "dog");
    private IndexWord CAT = Dictionary.getInstance().lookupIndexWord(POS.NOUN, "cat");
    private IndexWord FUNNY = Dictionary.getInstance().lookupIndexWord(POS.ADJECTIVE, "funny");
    private IndexWord DROLL = Dictionary.getInstance().lookupIndexWord(POS.ADJECTIVE, "droll");
    private String MORPH_PHRASE = "running-away";

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        String propsFile = args[0];
        try {
            JWNL.initialize(new FileInputStream(propsFile));
            new Examples().go();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public void go() throws JWNLException {
        this.demonstrateMorphologicalAnalysis(this.MORPH_PHRASE);
        this.demonstrateListOperation(this.ACCOMPLISH);
        this.demonstrateTreeOperation(this.DOG);
        this.demonstrateAsymmetricRelationshipOperation(this.DOG, this.CAT);
        this.demonstrateSymmetricRelationshipOperation(this.FUNNY, this.DROLL);
    }

    private void demonstrateMorphologicalAnalysis(String phrase2) throws JWNLException {
        System.out.println("Base form for \"" + phrase2 + "\": " + Dictionary.getInstance().lookupIndexWord(POS.VERB, phrase2));
    }

    private void demonstrateListOperation(IndexWord word) throws JWNLException {
        PointerTargetNodeList hypernyms = PointerUtils.getInstance().getDirectHypernyms(word.getSense(1));
        System.out.println("Direct hypernyms of \"" + word.getLemma() + "\":");
        hypernyms.print();
    }

    private void demonstrateTreeOperation(IndexWord word) throws JWNLException {
        PointerTargetTree hyponyms = PointerUtils.getInstance().getHyponymTree(word.getSense(1));
        System.out.println("Hyponyms of \"" + word.getLemma() + "\":");
        hyponyms.print();
    }

    private void demonstrateAsymmetricRelationshipOperation(IndexWord start, IndexWord end) throws JWNLException {
        RelationshipList list2 = RelationshipFinder.getInstance().findRelationships(start.getSense(1), end.getSense(1), PointerType.HYPERNYM);
        System.out.println("Hypernym relationship between \"" + start.getLemma() + "\" and \"" + end.getLemma() + "\":");
        Iterator itr = list2.iterator();
        while (itr.hasNext()) {
            ((Relationship)itr.next()).getNodeList().print();
        }
        System.out.println("Common Parent Index: " + ((AsymmetricRelationship)list2.get(0)).getCommonParentIndex());
        System.out.println("Depth: " + ((Relationship)list2.get(0)).getDepth());
    }

    private void demonstrateSymmetricRelationshipOperation(IndexWord start, IndexWord end) throws JWNLException {
        RelationshipList list2 = RelationshipFinder.getInstance().findRelationships(start.getSense(1), end.getSense(1), PointerType.SIMILAR_TO);
        System.out.println("Synonym relationship between \"" + start.getLemma() + "\" and \"" + end.getLemma() + "\":");
        Iterator itr = list2.iterator();
        while (itr.hasNext()) {
            ((Relationship)itr.next()).getNodeList().print();
        }
        System.out.println("Depth: " + ((Relationship)list2.get(0)).getDepth());
    }
}

