/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static void writeObject(File f2, Serializable obj) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f2));
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f2 + ": " + e);
        }
    }

    public static Object readObject(File f2) {
        String fname = f2.getName();
        if (fname.endsWith(".gz")) {
            return FileUtils.readGzippedObject(f2);
        }
        return FileUtils.readUnzippedObject(f2);
    }

    public static Object readUnzippedObject(File f2) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f2));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] readFile(File f2) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(f2));
        ArrayList<String> list2 = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            list2.add(line);
        }
        return list2.toArray(new String[0]);
    }

    public static File uniqueFile(File dir2, String prefix, String extension) throws IOException {
        File f2 = null;
        int i = 0;
        boolean wasCreated = false;
        while (!wasCreated) {
            f2 = dir2 != null ? new File(dir2, prefix + i + extension) : new File(prefix + i + extension);
            wasCreated = f2.createNewFile();
            ++i;
        }
        return f2;
    }

    public static void writeGzippedObject(File f2, Serializable obj) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f2))));
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f2 + ": " + e);
        }
    }

    public static Object readGzippedObject(File f2) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f2))));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

