/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.text.NumberFormat;
import java.util.Formatter;
import java.util.Locale;

public class FeatureCounter {
    double[] featureCounts;
    InstanceList instances;
    int numFeatures;
    int[] documentFrequencies;

    public FeatureCounter(InstanceList instances) {
        this.instances = instances;
        this.numFeatures = instances.getDataAlphabet().size();
        this.featureCounts = new double[this.numFeatures];
        this.documentFrequencies = new int[this.numFeatures];
    }

    public void count() {
        block7: {
            int index;
            block6: {
                TIntIntHashMap docCounts = new TIntIntHashMap();
                index = 0;
                if (this.instances.size() == 0) {
                    System.err.println("Instance list is empty");
                    return;
                }
                if (!(((Instance)this.instances.get(0)).getData() instanceof FeatureSequence)) break block6;
                for (Instance instance : this.instances) {
                    FeatureSequence features = (FeatureSequence)instance.getData();
                    for (int i = 0; i < features.getLength(); ++i) {
                        docCounts.adjustOrPutValue(features.getIndexAtPosition(i), 1, 1);
                    }
                    int[] keys = docCounts.keys();
                    for (int i = 0; i < keys.length - 1; ++i) {
                        int feature;
                        int n = feature = keys[i];
                        this.featureCounts[n] = this.featureCounts[n] + (double)docCounts.get(feature);
                        int n2 = feature;
                        this.documentFrequencies[n2] = this.documentFrequencies[n2] + 1;
                    }
                    docCounts = new TIntIntHashMap();
                    if (++index % 1000 != 0) continue;
                    System.err.println(index);
                }
                break block7;
            }
            if (!(((Instance)this.instances.get(0)).getData() instanceof FeatureVector)) break block7;
            for (Instance instance : this.instances) {
                FeatureVector features = (FeatureVector)instance.getData();
                for (int location = 0; location < features.numLocations(); ++location) {
                    int feature = features.indexAtLocation(location);
                    double value2 = features.valueAtLocation(location);
                    int n = feature;
                    this.documentFrequencies[n] = this.documentFrequencies[n] + 1;
                    int n3 = feature;
                    this.featureCounts[n3] = this.featureCounts[n3] + value2;
                }
                if (++index % 1000 != 0) continue;
                System.err.println(index);
            }
        }
    }

    public void printCounts() {
        Alphabet alphabet = this.instances.getDataAlphabet();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(6);
        nf.setGroupingUsed(false);
        for (int feature = 0; feature < this.numFeatures; ++feature) {
            Formatter formatter = new Formatter(new StringBuilder(), Locale.US);
            formatter.format("%s\t%s\t%d", alphabet.lookupObject(feature).toString(), nf.format(this.featureCounts[feature]), this.documentFrequencies[feature]);
            System.out.println(formatter);
        }
    }

    public static void main(String[] args) throws Exception {
        InstanceList instances = InstanceList.load(new File(args[0]));
        FeatureCounter counter = new FeatureCounter(instances);
        counter.count();
        counter.printCounts();
    }
}

