/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.PropertyHolder;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Token
implements Serializable,
PropertyHolder {
    private String text;
    PropertyList properties = null;
    PropertyList features = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Token(String s) {
        this.text = s;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t;
    }

    public String toString() {
        PropertyList.Iterator iter2;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText());
        if (this.features != null) {
            iter2 = this.features.iterator();
            while (iter2.hasNext()) {
                iter2.next();
                sb.append(" feature(" + iter2.getKey() + ")=" + iter2.getNumericValue());
            }
        }
        if (this.properties != null) {
            iter2 = this.properties.iterator();
            while (iter2.hasNext()) {
                iter2.next();
                if (iter2.isNumeric()) {
                    sb.append(" property(" + iter2.getKey() + ")=" + iter2.getNumericValue());
                    continue;
                }
                sb.append(" property(" + iter2.getKey() + ")=" + iter2.getObjectValue());
            }
        }
        return sb.toString();
    }

    public String toStringWithFeatureNames() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText());
        if (this.features != null) {
            PropertyList.Iterator iter2 = this.features.iterator();
            while (iter2.hasNext()) {
                iter2.next();
                sb.append(" " + iter2.getKey());
            }
        }
        return sb.toString();
    }

    @Override
    public FeatureVector toFeatureVector(Alphabet dict, boolean binary) {
        return new FeatureVector(dict, this.features, binary);
    }

    @Override
    public void setProperty(String key, Object value2) {
        this.properties = PropertyList.add(key, value2, this.properties);
    }

    @Override
    public void setNumericProperty(String key, double value2) {
        this.properties = PropertyList.add(key, value2, this.properties);
    }

    @Override
    public PropertyList getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(PropertyList newProperties) {
        this.properties = newProperties;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.lookupObject(key);
    }

    @Override
    public double getNumericProperty(String key) {
        return this.properties == null ? 0.0 : this.properties.lookupNumber(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.hasProperty(key);
    }

    @Override
    public void setFeatureValue(String key, double value2) {
        this.features = PropertyList.add(key, value2, this.features);
    }

    @Override
    public double getFeatureValue(String key) {
        return this.features == null ? 0.0 : this.features.lookupNumber(key);
    }

    @Override
    public PropertyList getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(PropertyList pl) {
        this.features = pl;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

