/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.util.CommandOption;
import java.util.LinkedHashMap;

public class StringKernel
extends LinkedHashMap {
    static final boolean DEFAULT_NORMALIZE_CASE = true;
    static final double DEFAULT_LAMBDA = 0.5;
    static final int DEFAULT_LENGTH = 3;
    static final boolean DEFAULT_CACHE = true;
    boolean normalizeCase;
    double lambda;
    int n;
    boolean cache;
    static CommandOption.String string1Option = new CommandOption.String(StringKernel.class, "string1", "FILE", true, null, "String one", null);
    static CommandOption.String string2Option = new CommandOption.String(StringKernel.class, "string2", "FILE", true, null, "String two", null);
    static final CommandOption.List commandOptions = new CommandOption.List("String Kernel.", new CommandOption[]{string1Option, string2Option});

    public StringKernel(boolean norm, double lam, int length, boolean cache) {
        this.normalizeCase = norm;
        this.lambda = lam;
        this.n = length;
        this.cache = cache;
    }

    public StringKernel() {
        this(true, 0.5, 3, true);
    }

    public StringKernel(boolean norm, double lam, int length) {
        this(norm, lam, length, true);
    }

    public double K(String s, String t) {
        double tt;
        double ss;
        Double sstmp = (Double)this.get(s);
        Double tttmp = (Double)this.get(t);
        if (sstmp == null) {
            ss = this.sK(s, s, this.n);
            if (this.cache) {
                this.put(s, new Double(ss));
            }
        } else {
            ss = sstmp;
        }
        if (tttmp == null) {
            tt = this.sK(t, t, this.n);
            if (this.cache) {
                this.put(t, new Double(tt));
            }
        } else {
            tt = tttmp;
        }
        double st = this.sK(s, t, this.n);
        return st / Math.sqrt(ss * tt);
    }

    private double sK(String s, String t, int n) {
        int k;
        int j;
        double r = 0.0;
        int slen = s.length();
        int tlen = t.length();
        double[][] K = new double[n + 1][(slen + 1) * (tlen + 1)];
        for (j = 0; j < slen + 1; ++j) {
            for (k = 0; k < tlen + 1; ++k) {
                K[0][k * (slen + 1) + j] = 1.0;
            }
        }
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < slen; ++j) {
                double sum2 = 0.0;
                for (k = 0; k < tlen; ++k) {
                    if (t.charAt(k) == s.charAt(j)) {
                        sum2 += K[i][k * (slen + 1) + j];
                    }
                    K[i + 1][(k + 1) * (slen + 1) + j + 1] = K[i + 1][(k + 1) * (slen + 1) + j] + sum2;
                }
            }
            r += K[i + 1][tlen * (slen + 1) + slen];
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        commandOptions.process(args);
        StringKernel sk = new StringKernel();
        System.err.println("String Kernel for " + StringKernel.string1Option.value + " and " + StringKernel.string2Option.value + " is " + sk.K(StringKernel.string1Option.value, StringKernel.string2Option.value));
    }
}

